/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activitiespanels;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.text.TextField;

public abstract class StringFeatureEditor
extends FeatureEditor<StringFeature> {
    protected StringFeatureEditor(UiContainer parent, StringFeature feature) {
        super(parent, feature);
    }

    public abstract void setText(String var1);

    public abstract String getText();

    public static TextFeatureEditor createText(UiContainer parent, StringFeature feature) {
        return new TextFeatureEditor(parent, feature);
    }

    public static ComboFeatureEditor createCombo(UiContainer parent, StringFeature feature) {
        return new ComboFeatureEditor(parent, feature);
    }

    @Override
    public StringFeature getFeature() {
        return (StringFeature)super.getFeature();
    }

    static class TextFeatureEditor
    extends StringFeatureEditor {
        private TextField textField;

        private TextFeatureEditor(UiContainer parent, StringFeature feature) {
            super(parent, feature);
            LabelMultiline descTextArea = this.createMsgArea((UiContainer)this);
            this.textField = new TextField((UiContainer)this, 20);
            UiUtilities.layoutComponentPanel((UiContainer)this, (LabelMultiline)descTextArea, (UiComponent)this.textField);
        }

        @Override
        public void toFeature() {
            this.getFeature().setValue(this.textField.getText());
        }

        @Override
        public void fromFeature() {
            this.textField.setText(this.getFeature().getValue());
        }

        public void setEnabled(boolean enabled) {
            this.textField.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void addDocumentListener(DocumentListener documentListener) {
            this.textField.addDocumentListener(documentListener);
        }

        @Override
        public String getText() {
            return this.textField.getText();
        }

        @Override
        public void setText(String text) {
            this.textField.setText(text);
        }
    }

    public static class ComboFeatureEditor
    extends StringFeatureEditor {
        private ComboBox<String> combo;

        protected ComboFeatureEditor(UiContainer parent, StringFeature feature) {
            super(parent, feature);
            this.buildUI(feature);
        }

        public void addItemListener(ItemListener listener) {
            this.combo.addItemListener(listener);
        }

        public String getSelectedItem() {
            return (String)this.combo.getSelectedItem();
        }

        @Override
        public void toFeature() {
            this.getFeature().setValue((String)this.combo.getSelectedItem());
        }

        @Override
        public void fromFeature() {
            this.combo.setSelectedItem((Object)this.getFeature().getValue());
        }

        public void setLabelProvider(LabelProvider<String> labelProvider) {
            this.combo.setLabelProvider(labelProvider);
        }

        @Override
        public void setText(String text) {
            this.combo.setSelectedItem((Object)text);
        }

        @Override
        public String getText() {
            if (this.getSelectedItem() == null) {
                return null;
            }
            return this.getSelectedItem();
        }

        public void addItem(String name) {
            this.getComboField().addItem((Object)name);
        }

        public void setSelectedItem(String object) {
            this.getComboField().setSelectedItem((Object)object);
        }

        public void removeAllItems() {
            this.getComboField().removeAllItems();
        }

        protected void buildUI(StringFeature feature) {
            LabelMultiline descTextArea = this.createMsgArea((UiContainer)this);
            Collection validValues = feature.getValidValues();
            ArrayList l = new ArrayList();
            if (validValues.size() > 0) {
                l.addAll(validValues);
            }
            this.combo = UiFactory.createMutableComboBox((UiContainer)this, l);
            UiUtilities.layoutComponentPanel((UiContainer)this, (LabelMultiline)descTextArea, this.combo);
        }

        protected ComboBox<String> getComboField() {
            return this.combo;
        }
    }
}

