/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activitiespanels;

import oracle.bpm.draw.Font;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;

public abstract class FeatureEditor<T extends Feature>
extends Panel {
    private final T feature;

    protected FeatureEditor(UiContainer parent, T feature) {
        super(parent, feature.getLabel());
        this.feature = feature;
    }

    protected FeatureEditor(UiContainer parent, T feature, boolean hasTitle) {
        super(parent, hasTitle ? feature.getLabel() : UIMsg.TO_MSG((String)""));
        this.feature = feature;
    }

    public abstract void toFeature();

    public abstract void fromFeature();

    public T getFeature() {
        return this.feature;
    }

    public void check() throws ProjectException {
    }

    protected CheckBox createCheckBox(UiContainer parent) {
        T feature = this.getFeature();
        return CheckBox.create((UiContainer)parent, (Msg)feature.getLabel());
    }

    protected LabelMultiline createMsgArea(UiContainer parent) {
        T feature = this.getFeature();
        Msg description = feature.getDescription();
        if (description == null) {
            return null;
        }
        return this.createMsgArea(parent, description);
    }

    protected LabelMultiline createMsgArea(UiContainer parent, Msg description) {
        LabelMultiline msgTextArea = new LabelMultiline(parent, description);
        Font font = Ui.getToolkit().getDefaultFont();
        msgTextArea.setFont(font);
        msgTextArea.enableInputMethods(false);
        msgTextArea.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.DEFAULT_CURSOR));
        msgTextArea.setFocusable(false);
        return msgTextArea;
    }
}

