/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.activitiespanels;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.resources.Labeled;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ItemListener;

public abstract class EnumFeatureEditor<E extends Enum<E>>
extends FeatureEditor<EnumFeature<E>> {
    private EnumFeatureEditor(UiContainer parent, EnumFeature<E> feature) {
        super(parent, feature);
    }

    public abstract void addItemListener(ItemListener var1);

    public abstract void setDefault();

    public static <E extends Enum<E>> EnumFeatureEditor<E> createRadio(UiContainer parent, EnumFeature<E> feature) {
        return EnumFeatureEditor.createRadio(parent, feature, false);
    }

    public static <E extends Enum<E>> EnumFeatureEditor<E> createRadio(UiContainer parent, EnumFeature<E> feature, boolean horizontalAlignment) {
        return new RadioEnumFeatureEditor<E>(parent, feature, horizontalAlignment);
    }

    public static <E extends Enum<E>> EnumFeatureEditor<E> createCombo(UiContainer parent, EnumFeature<E> feature) {
        return new ComboEnumFeatureEditor(parent, feature);
    }

    @Override
    public EnumFeature<E> getFeature() {
        return (EnumFeature)super.getFeature();
    }

    @Override
    public void toFeature() {
        this.getFeature().setValue(this.getSelectedEnumValue());
    }

    @Override
    public void fromFeature() {
        this.setSelectedEnumValue(this.getFeature().getValue());
    }

    protected abstract E getSelectedEnumValue();

    protected abstract void setSelectedEnumValue(E var1);

    static class RadioEnumFeatureEditor<E extends Enum<E>>
    extends EnumFeatureEditor<E> {
        private boolean horizontalAlignment;
        private TreeMap<E, RadioButton> radioButtons;

        RadioEnumFeatureEditor(UiContainer parent, EnumFeature<E> feature, boolean horizontalAlignment) {
            super(parent, feature);
            this.horizontalAlignment = horizontalAlignment;
            this.build();
        }

        public boolean isHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public void setEnabled(boolean enabled) {
            for (RadioButton radioButton : this.getRadioButtons().values()) {
                radioButton.setEnabled(enabled);
            }
            super.setEnabled(enabled);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            Collection<RadioButton> radioButtons = this.getRadioButtons().values();
            for (RadioButton radioButton : radioButtons) {
                radioButton.addItemListener(itemListener);
            }
        }

        @Override
        public void setDefault() {
            this.setSelectedEnumValue(this.getFeature().getDefault());
        }

        @Override
        protected E getSelectedEnumValue() {
            for (Map.Entry<E, RadioButton> entry : this.getRadioButtons().entrySet()) {
                if (!entry.getValue().isSelected()) continue;
                return (E)((Enum)entry.getKey());
            }
            return null;
        }

        @Override
        protected void setSelectedEnumValue(E value) {
            RadioButton radioButton = this.getRadioButtons().get(value);
            radioButton.setSelected(true);
        }

        protected TreeMap<E, RadioButton> getRadioButtons() {
            return this.radioButtons;
        }

        private void build() {
            this.radioButtons = new TreeMap(new Comparator<E>(){

                @Override
                public int compare(E o1, E o2) {
                    return ((Enum)o1).ordinal() - ((Enum)o2).ordinal();
                }
            });
            ButtonGroup group = new ButtonGroup();
            for (Enum anEnum : this.getFeature().getEnumValues()) {
                String title;
                if (anEnum instanceof Labeled) {
                    Labeled internationalizable = (Labeled)((Object)anEnum);
                    title = internationalizable.getLabel().getString();
                } else {
                    title = anEnum.toString();
                }
                RadioButton radioButton = new RadioButton((UiContainer)this, title);
                this.getRadioButtons().put(anEnum, radioButton);
                group.add((AbstractButton)radioButton);
            }
            LabelMultiline descTextArea = this.createMsgArea((UiContainer)this);
            UiUtilities.layoutRadioButtonPanel((UiContainer)this, (LabelMultiline)descTextArea, (RadioButton[])this.getRadioButtons().values().toArray(new RadioButton[0]), (boolean)this.isHorizontalAlignment());
        }
    }

    static class ComboEnumFeatureEditor<E extends Enum<E>>
    extends EnumFeatureEditor<E> {
        private ComboBox<E> combo;

        private ComboEnumFeatureEditor(UiContainer parent, EnumFeature<E> feature) {
            super(parent, feature);
            this.combo = UiFactory.createComboBox((UiContainer)this, (Object[])feature.getEnumValues());
            LabelMultiline descTextArea = this.createMsgArea((UiContainer)this);
            UiUtilities.layoutComponentPanel((UiContainer)this, (LabelMultiline)descTextArea, this.combo);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.combo.addItemListener(itemListener);
        }

        @Override
        public void setDefault() {
            this.combo.setSelectedItem((Object)this.getFeature().getDefault());
        }

        @Override
        protected E getSelectedEnumValue() {
            return (E)((Enum)this.combo.getSelectedItem());
        }

        @Override
        protected void setSelectedEnumValue(Enum value) {
            this.combo.setSelectedItem((Object)value);
        }
    }
}

