/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.provider;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.AddFlowNodesActionGroup;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.QuadCurve;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

@ActionGroupMetadata(target=SequenceFlow.class)
public class SequenceFlowActions
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        ActionGroup result = new ActionGroup(DesignerMsg.SEQUENCE_FLOW);
        this.addStyleActions(result);
        SequenceFlow sequenceFlow = context.as(SequenceFlow.class);
        result.add((BaseAction)new AddFlowNodesActionGroup(sequenceFlow.getParentObject(), DesignerMsg.INSERT, sequenceFlow));
        return result;
    }

    private void addStyleActions(ActionGroup result) {
        ActionGroup styles = new ActionGroup(DesignerMsg.STYLE);
        styles.add((BaseAction)new StraightRoutingAction());
        styles.add((BaseAction)new CurvedRoutingAction());
        styles.add((BaseAction)new OrthogonalRoutingAction());
        result.add((BaseAction)styles);
    }

    private static class StraightRoutingAction
    extends RoutingAction {
        private StraightRoutingAction() {
            super(DesignerMsg.STRAIGHT, RoutingMode.STRAIGHT);
        }

        @Override
        protected Point calculateControl(@NotNull SequenceFlow flow) {
            return SequenceFlow.NULL_CONTROL_POINT;
        }
    }

    private static class OrthogonalRoutingAction
    extends RoutingAction {
        private OrthogonalRoutingAction() {
            super(DesignerMsg.ORTHOGONAL, RoutingMode.ORTHOGONAL);
        }

        @Override
        protected Point calculateControl(@NotNull SequenceFlow flow) {
            SequenceFlow sequenceFlow = this.getSequenceFlow();
            Point start = sequenceFlow.getSource().getLocation();
            Point end = sequenceFlow.getTarget().getLocation();
            Cloneable path = sequenceFlow.getRoutingMode().equals((Object)RoutingMode.STRAIGHT) || SequenceFlow.NULL_CONTROL_POINT.equals(sequenceFlow.getControlPoint()) ? new Line(start, end) : new QuadCurve(start, sequenceFlow.getControlPoint(), end);
            return new Point(path.eval(0.5));
        }
    }

    private static class CurvedRoutingAction
    extends RoutingAction {
        private CurvedRoutingAction() {
            super(DesignerMsg.CURVED, RoutingMode.CURVED);
        }

        @Override
        protected Point calculateControl(@NotNull SequenceFlow flow) {
            SequenceFlow sequenceFlow = this.getSequenceFlow();
            Point start = sequenceFlow.getSource().getLocation();
            Point end = sequenceFlow.getTarget().getLocation();
            Point ctrl = sequenceFlow.getRoutingMode().equals((Object)RoutingMode.STRAIGHT) || SequenceFlow.NULL_CONTROL_POINT.equals(sequenceFlow.getControlPoint()) ? QuadCurve.calculateControlPoint(start, end, CurvedRoutingAction.controlPointOffset(start.getX(), end.getX())) : QuadCurve.calculateControlPoint(start, sequenceFlow.getControlPoint(), end);
            return ctrl;
        }

        private static int controlPointOffset(int xf, int xt) {
            return 25 * (1 + Math.abs(xf - xt) / 100);
        }
    }

    private static abstract class RoutingAction
    extends DesignerAction {
        private final RoutingMode mode;

        protected RoutingAction(@NotNull Msg msg, @NotNull RoutingMode mode) {
            super(msg);
            this.mode = mode;
            this.requires(SequenceFlow.class);
        }

        @Override
        public void run() {
            SequenceFlow flow = this.getSequenceFlow();
            this.getRunner().run((Command)new ChangeSequenceFlowRoutingDataCommand(flow, this.mode, this.calculateControl(flow)));
        }

        protected abstract Point calculateControl(@NotNull SequenceFlow var1);

        protected void updateEnableStatus(Selection selection) {
            this.setEnabled(this.getSequenceFlow().getRoutingMode() != this.mode);
        }

        protected SequenceFlow getSequenceFlow() {
            return (SequenceFlow)this.getSelection().as(SequenceFlow.class);
        }
    }
}

