/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.provider;

import java.util.EnumSet;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Function;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

@ActionGroupMetadata(target=Gateway.class)
public class GatewayMutateToActions
implements ActionGroupFactory {
    private static final EnumSet<BpmnType> GATEWAY_MUTATE_TO_TYPES = EnumSet.of(BpmnType.COMPLEX_GATEWAY, BpmnType.INCLUSIVE_GATEWAY, BpmnType.PARALLEL_GATEWAY);

    public ActionGroup create(Adaptable context) {
        Gateway gateway = context.as(Gateway.class);
        ActionGroup result = new ActionGroup();
        if (gateway.getDirection() == GatewayDirection.CONVERGING) {
            ActionGroup gateways = new ActionGroup(DesignerMsg.TO_GATEWAY, new Class[]{Gateway.class});
            BpmnType original = gateway.getBpmnType();
            for (BpmnType type : GATEWAY_MUTATE_TO_TYPES) {
                if (type == original) continue;
                gateways.add((BaseAction)new ChangeGatewayTypeAction(type));
            }
            result.add((BaseAction)gateways);
        }
        return result;
    }

    private static final class MutateGatewayFunction
    implements Function<FlowNode, FlowNode> {
        private final BpmnType type;

        public MutateGatewayFunction(@NotNull BpmnType type) {
            this.type = type;
        }

        @Override
        public FlowNode eval(@NotNull FlowNode value) {
            Gateway gateway = (Gateway)value.asAnyNode(Gateway.class);
            if (gateway != null) {
                ActionRunner.getInstance().run((Command)((Object)new ChangeGatewayTypeCommand(gateway, this.type)));
            }
            return gateway;
        }
    }

    public static final class ChangeGatewayTypeCommand
    extends ProjectCommand {
        private final Gateway gateway;
        private final BpmnType type;

        public ChangeGatewayTypeCommand(@NotNull Gateway gateway, @NotNull BpmnType type) {
            super(new ProjectObject[0]);
            this.gateway = gateway;
            this.type = type;
        }

        public String getName() {
            return this.type.getString();
        }

        public Object execute() throws ExecutionException {
            Gateway associated = this.gateway.getMergingGateway();
            if (associated != null) {
                if (this.type != BpmnType.COMPLEX_GATEWAY) {
                    this.to(associated, this.type);
                }
                this.to(this.gateway, this.type);
            }
            return null;
        }

        private void to(@NotNull Gateway gateway, @NotNull BpmnType type) {
            switch (type) {
                case COMPLEX_GATEWAY: {
                    gateway.toComplexGateway();
                    break;
                }
                case PARALLEL_GATEWAY: {
                    gateway.toParallel();
                    break;
                }
                case INCLUSIVE_GATEWAY: {
                    gateway.toInclusive();
                }
            }
        }
    }

    public static final class ChangeGatewayTypeAction
    extends DesignerAction {
        private BpmnType type;

        public ChangeGatewayTypeAction(@NotNull BpmnType type) {
            super(type.getLabel());
            DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
            this.setSmallIcon(theme.getImageFor(FlowFigureUtils.fromType((BpmnType)type), ImageType.ICON));
            this.requires(Gateway.class);
            this.type = type;
        }

        @Override
        public void run() {
            FlowNodePropertiesPreferences preferences = FlowNodePropertiesPreferences.create();
            preferences.addAfterCopyFunction(new MutateGatewayFunction(this.type));
            preferences.setSelectedSheet(FlowNodePropertiesPreferences.SHOW_IMPLEMENTATION);
            FlowNodePropertiesDialog.editProperties((FlowNode)this.getGateway(), preferences);
        }

        private Gateway getGateway() {
            return (Gateway)this.getSelection().as(Gateway.class);
        }
    }
}

