/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.provider;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.action.FlowNodePropertiesAction;
import oracle.bpm.designer.action.GenerateElementImageAction;
import oracle.bpm.designer.action.HighlightAuditImageElementAction;
import oracle.bpm.designer.action.LanePropertiesAction;
import oracle.bpm.designer.action.ProcessPropertiesAction;
import oracle.bpm.designer.action.SequenceFlowPropertiesAction;
import oracle.bpm.designer.measurementmark.MeasurementPropertiesAction;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=FlowElement.class)
public class FlowElementPropertiesActions
implements ActionGroupFactory {
    private static final boolean STUDIO_DEBUG_MODE = System.getProperty("fuego.studio.debug") != null;

    public ActionGroup create(Adaptable context) {
        FlowElement flowElement = context.as(FlowElement.class);
        ActionGroup result = new ActionGroup();
        result.setOrder(ActionOrder.FIRST);
        Class rawClass = flowElement.getRawClass();
        if (Lane.class.isAssignableFrom(rawClass)) {
            result.add((BaseAction)LanePropertiesAction.getInstance());
        } else if (FlowNode.class.isAssignableFrom(rawClass)) {
            result.add((BaseAction)FlowNodePropertiesAction.getInstance());
        } else if (Measurement.class.isAssignableFrom(rawClass)) {
            result.add((BaseAction)MeasurementPropertiesAction.getInstance());
        } else if (SequenceFlow.class.isAssignableFrom(rawClass)) {
            result.add((BaseAction)SequenceFlowPropertiesAction.getInstance());
        } else if (Process.class.isAssignableFrom(rawClass)) {
            result.add((BaseAction)ProcessPropertiesAction.getInstance());
        }
        if (STUDIO_DEBUG_MODE) {
            result.add((BaseAction)GenerateElementImageAction.getInstance());
            result.add((BaseAction)HighlightAuditImageElementAction.getInstance());
        }
        return result;
    }
}

