/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.organization;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.designer.action.organization.AbstractOrganizationAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.io.serializers.organization.ParseListener;
import oracle.bpm.project.io.serializers.organization.ProjectFileHandlerFactory;
import oracle.bpm.project.io.serializers.organization.ProjectObjectParser;
import oracle.bpm.project.io.serializers.organization.ProjectSourceHandler;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.FileChooser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportOrganizationAction
extends AbstractOrganizationAction {
    public ImportOrganizationAction(Organization organization) {
        super(DesignerMsg.IMPORT_FDI, organization);
        this.requires(Organization.class);
    }

    public void run() {
        File importFile = this.selectImportFile();
        if (importFile != null) {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                InputSource inputSource = new InputSource(new FileInputStream(importFile));
                ProjectSourceHandler handler = ProjectFileHandlerFactory.createProjectHandler((Project)this.getOrganization().getProject(), null);
                handler.addParseListener(new ParseListener(){

                    public void objectParsed(ProjectObjectParser parser, ProjectObject projectObject) throws ProjectException {
                        parser.addToModel(projectObject);
                    }

                    public ProjectObject getObjectParsed() {
                        return null;
                    }

                    public ProjectObjectParser getProjectObjectParser() {
                        return null;
                    }
                });
                parser.parse(inputSource, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                MessageDialog.showError((Throwable)e);
            }
            catch (IOException e) {
                MessageDialog.showError((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private File selectImportFile() {
        FileChooser fc = this.getFileChooser();
        int res = fc.showOpenDialog((UiComponent)Ui.getRoot());
        return res == 0 ? fc.getSelectedFile() : null;
    }
}

