/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.organization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.bpm.designer.action.organization.AbstractOrganizationAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Literals;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializerFactory;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.filechooser.FileChooser;

public class ExportOrganizationAction
extends AbstractOrganizationAction {
    public ExportOrganizationAction(Organization organization) {
        super(DesignerMsg.EXPORT, organization);
        this.requires(Organization.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File exportFile;
        int option = 2;
        do {
            if ((exportFile = this.selectExportFile()) != null && !exportFile.getName().endsWith(".xdml")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".xdml");
            }
            if (exportFile == null || !exportFile.exists()) continue;
            option = MessageDialog.showQuestion((UiContainer)null, (Msg)CoreMsg.WARNING, (Msg)DesignerMsg.FILE_EXISTS_OVEWRITE, null, (int)14, null);
        } while (option == 4 && exportFile != null);
        if (exportFile != null) {
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter writer = null;
            try {
                fileOutputStream = new FileOutputStream(exportFile);
                writer = new OutputStreamWriter((OutputStream)fileOutputStream, Literals.DEFAULT_ENCODING);
                ProjectObjectSerializer serializer = ProjectObjectSerializerFactory.getSerializer((ProjectObject)this.getOrganization());
                serializer.write((Writer)writer, (ProjectObject)this.getOrganization());
            }
            catch (Exception e) {
                try {
                    MessageDialog.showError((Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(fileOutputStream);
                    StreamUtils.close(writer);
                    throw throwable;
                }
                StreamUtils.close(fileOutputStream);
                StreamUtils.close(writer);
            }
            StreamUtils.close(fileOutputStream);
            StreamUtils.close(writer);
        }
    }

    private File selectExportFile() {
        FileChooser fc = this.getFileChooser();
        int res = fc.showSaveDialog((UiComponent)Ui.getRoot());
        return res == 0 ? fc.getSelectedFile() : null;
    }
}

