/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action.organization;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.dialog.AbstractDialog;
import oracle.bpm.resources.Msg;

public abstract class AbstractNewObjectAction<OT>
extends DesignerAction {
    private boolean haveToOpenEditor;
    private OT objectAdded;

    public AbstractNewObjectAction(Msg msg, boolean haveToOpenEditor) {
        super(msg);
        this.haveToOpenEditor = haveToOpenEditor;
    }

    @Override
    public void run() {
        OT addedObject;
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        AbstractDialog<OT> dialog = this.getNewObjectDialog();
        dialog.setVisible(true);
        if (!dialog.userAccepted()) {
            return;
        }
        this.setObjectAdded(dialog.getProjectObjectAdded());
        if (this.isHaveToOpenEditor() && (addedObject = this.getObjectAdded()) != null) {
            StudioEditor editor = workbench.findEditorByObject(addedObject);
            if (editor == null) {
                workbench.openEditorForObject(addedObject);
            }
            workbench.activateEditorForInput(addedObject);
        }
    }

    public boolean isHaveToOpenEditor() {
        return this.haveToOpenEditor;
    }

    public void setObjectAdded(OT objectAdded) {
        this.objectAdded = objectAdded;
    }

    public OT getObjectAdded() {
        return this.objectAdded;
    }

    protected abstract AbstractDialog<OT> getNewObjectDialog();
}

