/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProcessEditor;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.project.model.exception.InvalidLocationException;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;

public class SnapToGridAction
extends BaseAction {
    private static SnapToGridAction instance;

    private SnapToGridAction() {
        super(DesignerMsg.SNAPTOGRID);
        this.requires(Void.class);
        this.setSelected(DesignerPreferences.getPreferences().getSnapToGrid());
    }

    public static SnapToGridAction getInstance() {
        if (instance == null) {
            instance = new SnapToGridAction();
        }
        return instance;
    }

    public static void snapToGrid() {
        ProcessEditor[] editors;
        for (ProcessEditor editor : editors = (ProcessEditor[])AbstractStudioWorkbench.getInstance().getEditorsByClass(ProcessEditor.class)) {
            ProcessPanel panel = editor.getProcessPanel();
            if (panel == null || panel.getModel() == null) continue;
            SnapToGridAction.snapToGrid(panel.getModel());
        }
    }

    public static void snapToGrid(Process model) {
        try {
            Grid grid = new Grid(DesignerPreferences.getPreferences().getGridSize());
            grid.snap(model);
        }
        catch (InvalidLocationException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    public void run() {
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        boolean grid = !designerPreferences.getSnapToGrid();
        this.setSelected(grid);
        designerPreferences.setSnapToGrid(grid);
        if (grid) {
            SnapToGridAction.snapToGrid();
        }
        designerPreferences.store();
        AbstractStudioWorkbench.repaintAllDesigns();
    }
}

