/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.action.CopyPresentationAction;
import oracle.bpm.designer.action.PresentationNameValidator;
import oracle.bpm.designer.action.RemoveComponentPresentationAction;
import oracle.bpm.designer.catalog.tree.ObjectPresentationTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class RenamePresentationAction
extends DesignerAction {
    private String name;
    private ObjectPresentationTreeNode presentation;
    private XObjectTypeDescription xotd;

    public RenamePresentationAction(ObjectPresentationTreeNode presentation, XObjectTypeDescription xotd) {
        super(DesignerMsg.RENAME);
        this.requires(XFormPresentationModel.class);
        this.presentation = presentation;
        this.xotd = xotd;
    }

    @Override
    public boolean doIt() {
        return this.renamePresentation();
    }

    public void unDoIt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rename() {
        DesignerApplication instance = DesignerApplication.getInstance();
        try {
            instance.setCursor(Cursor.WAIT_CURSOR);
            boolean result = new CopyPresentationAction(this.presentation, this.xotd, this.name).copy();
            if (result) {
                result = new RemoveComponentPresentationAction(this.presentation, this.xotd, false).doIt();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            instance.setCursor(Cursor.DEFAULT_CURSOR);
        }
    }

    private boolean renamePresentation() {
        String oldName = this.presentation.getPresentationModel().getPresentationName();
        this.name = MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.PRESENTATION_NAME, (Msg)DesignerMsg.RENAME, (InputValidator)((Object)new PresentationNameValidator(this.xotd)), (String)oldName, (boolean)true, (boolean)true);
        return this.name != null && !Any.equals(oldName, this.name) && this.showConfirmationDialog() && this.rename();
    }

    private boolean showConfirmationDialog() {
        return DialogFactory.showConfirmDialog((HiddenMessagesPreferences)DesignerPreferences.getPreferences(), (Msg)DesignerMsg.RENAME, (Msg)DesignerMsg.CONFIRM_RENAME_PRESENTATION);
    }
}

