/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.BPMObjectAttributeInputValidator;
import oracle.bpm.designer.action.BPMObjectMethodInputValidator;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.NewMethodAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

public class RenameMemberAction
extends DesignerAction {
    private MethodTypeDescription member;
    private String name;
    private String newName;
    static final long serialVersionUID = 1886463743378723236L;
    static final long serialCheck = 2954495193616367010L;

    public RenameMemberAction(MethodTypeDescription selectedNode) {
        this(selectedNode, null);
    }

    public RenameMemberAction(MethodTypeDescription selectedNode, String newName) {
        super(DesignerMsg.RENAME);
        this.requires(MethodTypeDescription.class);
        this.member = selectedNode;
        this.newName = newName;
    }

    public void setGroupAttribute(boolean groupAttribute) {
    }

    @Override
    public boolean doIt() {
        boolean isNewName = !this.member.getName().equals(this.newName);
        return isNewName && this.rename();
    }

    public boolean rename() {
        boolean result;
        ObjectTypeDescription parent = this.member.getParent().asObject();
        if (this.member.isConstructor()) {
            result = this.showConstructorConfirmationDialog();
            if (result) {
                // empty if block
            }
        } else {
            result = this.getAValidName(parent);
            if (result) {
                this.rename(parent, this.member);
            }
        }
        return result;
    }

    public void rename(ObjectTypeDescription parent, MethodTypeDescription member) {
        OpenCloseMemberAction.closeMember(member);
        this.renameReferences(parent);
        parent.renameMember(member, this.name);
        CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)parent);
        FuegoObjectAction.storeObjectIfEditorIsNotActive(catalogObject);
    }

    public void unDoIt() {
    }

    private boolean getAValidName(ObjectTypeDescription parent) {
        this.name = this.newName;
        boolean result = this.name == null ? this.promptForNewName(this.member) : this.validateName(parent);
        if (result) {
            NewMethodAction.AccessorValidator av = new NewMethodAction.AccessorValidator(this.name, this.member.getParent().asObject());
            if (av.isAccessor()) {
                int answer = MessageDialog.showQuestion((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.ADD_METHOD, (Msg)av.getMsg(), null, (int)0, null);
                if (answer == 1 || answer == 2) {
                    return av.executeEditAccessor();
                }
                if (answer == 8) {
                    return false;
                }
            }
            result = this.showMemberConfirmationDialog(this.member);
        }
        return result;
    }

    private boolean closeEditors() {
        return true;
    }

    private boolean promptForNewName(MethodTypeDescription member) {
        this.name = member.isAttribute() ? MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.NEW_NAME, (Msg)DesignerMsg.RENAME, (InputValidator)new BPMObjectAttributeInputValidator(member.getParent().asObject()), (String)member.getName(), (int)256) : MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.NEW_NAME, (Msg)DesignerMsg.RENAME, (String)member.getName(), (InputValidator)new BPMObjectMethodInputValidator(member.getParent().asObject()));
        return this.name != null;
    }

    private boolean renameReferences(ObjectTypeDescription parent) {
        boolean result = this.closeEditors();
        if (result && this.member.isAttribute()) {
            this.renameValidValuesInvocation(parent);
        }
        return result;
    }

    private void renameValidValuesInvocation(ObjectTypeDescription parent) {
        MethodTypeDescription mtd = this.member.getParent().asObject().findMethod(this.member.getName() + "ValidValues");
        if (mtd != null) {
            parent.renameMember(mtd, this.name + "ValidValues");
        }
    }

    private boolean showMemberConfirmationDialog(MethodTypeDescription method) {
        return DialogFactory.showConfirmDialog((HiddenMessagesPreferences)DesignerPreferences.getPreferences(), (Msg)DesignerMsg.RENAME, (Msg)(method.isAttribute() ? DesignerMsg.CONFIRM_RENAME_ATTRIBUTE : DesignerMsg.CONFIRM_RENAME_METHOD));
    }

    private boolean showConstructorConfirmationDialog() {
        String xoName = this.member.getParent().getName();
        return DialogFactory.showConfirmDialog((Msg)DesignerMsg.RENAME, (Msg)DesignerMsg.CONFIRM_RENAME_CONSTRUCTOR(xoName));
    }

    private boolean validateName(ObjectTypeDescription parent) {
        boolean result = false;
        if (this.member.isAttribute()) {
            try {
                new BPMObjectAttributeInputValidator(parent).validate(this.name);
                result = true;
            }
            catch (InputValidationException e) {
                MessageDialog.showError((Msg)DesignerMsg.ATTRIBUTE_NAME, (Msg)e.getKey());
                return false;
            }
        }
        if (this.member.isMethod()) {
            try {
                new BPMObjectMethodInputValidator(parent).validate(this.name);
                result = true;
            }
            catch (InputValidationException e) {
                MessageDialog.showError((Msg)DesignerMsg.WRONGNAME, (Msg)e.getKey());
                return false;
            }
        }
        return result;
    }
}

