/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.Identifier;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class RenameGroupAction
extends FuegoObjectAction {
    private ObjectTypeDescription groupObject;
    private String newName;

    public RenameGroupAction() {
        super(DesignerMsg.RENAME);
        this.requires(ObjectTypeDescription.class);
        this.requires(AttributeTypeDescription.class);
        this.requires(CatalogObject.class);
    }

    public RenameGroupAction(AttributeTypeDescription currentAttribute, String newName) {
        this();
        this.groupObject = (ObjectTypeDescription)currentAttribute.getResultType().getElementType();
        this.newName = newName;
    }

    @Override
    public void run() {
        ObjectTypeDescription ref = this.getObject();
        if (ref != null) {
            String name;
            ObjectTypeDescription nodeToRename = ref;
            boolean result = false;
            while ((name = this.promptForName(nodeToRename)) != null) {
                ObjectTypeDescription groupParent = nodeToRename.getParent().asObject();
                if (name.equalsIgnoreCase(nodeToRename.getName())) break;
                boolean validName = false;
                try {
                    validName = XObjectTypeDescriptionHelper.isValidGroupName((ObjectTypeDescription)groupParent, (String)name);
                }
                catch (ConstructionException e) {
                    MessageDialog.showNotice((Msg)UIMsg.TO_MSG((String)e.getMessage()));
                }
                if (validName) {
                    result = this.showConfirmationDialog();
                    if (!result) break;
                    result = this.rename(nodeToRename, name, groupParent);
                }
                if (!result) continue;
            }
        }
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        ObjectTypeDescription object = this.getObject();
        CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)object);
        this.setEnabled(object.isInnerType() && this.isEditable(catalogObject));
    }

    private ObjectTypeDescription getObject() {
        if (this.groupObject != null) {
            return this.groupObject;
        }
        return this.getGroupObjectFromSelection();
    }

    private ObjectTypeDescription getGroupObjectFromSelection() {
        ObjectTypeDescription result = (ObjectTypeDescription)this.getSelection().as(ObjectTypeDescription.class);
        if (result == null) {
            result = (ObjectTypeDescription)((AttributeTypeDescription)this.getSelection().as(AttributeTypeDescription.class)).getResultType().getElementType();
        }
        return result;
    }

    private boolean rename(ObjectTypeDescription nodeToRename, String name, ObjectTypeDescription groupParent) {
        try {
            ObjectTypeDescription newNode = nodeToRename.clone();
            newNode.setName(Identifier.classname(name));
            ObjectTypeDescription XOParent = groupParent;
            XObjectTypeDescriptionHelper.removeMember((ObjectTypeDescription)XOParent, (String)Identifier.attribute(nodeToRename.getName()));
            this.removeFromRepository(nodeToRename);
            groupParent.addInnerType(newNode);
            String groupName = this.getUncapitalizedName(name);
            XObjectTypeDescriptionHelper.addGroupAttribute((ObjectTypeDescription)XOParent, (String)groupName, (ObjectTypeDescription)newNode);
            return this.addToRepository(newNode, groupParent);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        catch (TypeCatalogException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
    }

    private String getUncapitalizedName(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private boolean addToRepository(ObjectTypeDescription newNode, ObjectTypeDescription groupParent) {
        try {
            MutableComponentCatalog catalog = RenameGroupAction.getTypeRepository(newNode);
            catalog.add(newNode);
            catalog.update(groupParent);
            return true;
        }
        catch (TypeCatalogException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
    }

    private String promptForName(ObjectTypeDescription member) {
        if (this.newName != null) {
            String suggestedName = this.newName;
            this.newName = null;
            return suggestedName;
        }
        String oldName = this.getUncapitalizedName(member.getName());
        String result = MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.RENAME, (Msg)DesignerMsg.NEW_NAME, null, (String)oldName);
        if (result != null) {
            char firstLetter = result.charAt(0);
            result = Character.toString(firstLetter).toLowerCase() + result.substring(1);
        }
        return result;
    }

    private void removeFromRepository(ObjectTypeDescription nodeToRename) throws TypeCatalogException {
        String oldNodeName = nodeToRename.get().getText();
        RenameGroupAction.getTypeRepository(nodeToRename).remove(oldNodeName);
    }

    private boolean showConfirmationDialog() {
        return DialogFactory.showConfirmDialog((HiddenMessagesPreferences)DesignerPreferences.getPreferences(), (Msg)DesignerMsg.RENAME, (Msg)DesignerMsg.CONFIRM_RENAME_GROUP);
    }
}

