/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.RemoveComponentMemberAction;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.designer.catalog.tree.ObjectPresentationTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class RemoveComponentPresentationAction
extends RemoveComponentMemberAction {
    private final boolean confirm;
    private XObjectTypeDescription modelParent;
    private XFormPresentationModel presentation;

    public RemoveComponentPresentationAction(ObjectPresentationTreeNode node, XObjectTypeDescription parent) {
        this(node, parent, true);
    }

    public RemoveComponentPresentationAction(ObjectPresentationTreeNode node, XObjectTypeDescription parent, boolean confirm) {
        super(UIMsg.MENU_DELETE);
        this.confirm = confirm;
        this.requires(XFormPresentationModel.class);
        this.presentation = node.getPresentationModel();
        this.modelParent = parent;
    }

    @Override
    public boolean doIt() {
        return this.removeMember();
    }

    @Override
    protected void closeEditor() {
        BPMObjectEditor bpmObjectEditor = RemoveComponentPresentationAction.getEditor();
        if (bpmObjectEditor != null) {
            bpmObjectEditor.closePresentation(this.presentation);
        }
    }

    private boolean removeMember() {
        String name = this.presentation.getPresentationName();
        if (!this.confirm || this.confirmDeletePresentation()) {
            this.closeEditor();
            XObjectTypeDescriptionHelper.removeModel((XObjectTypeDescription)this.modelParent, (String)name);
            CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)this.modelParent);
            FuegoObjectAction.storeObjectIfEditorIsNotActive(catalogObject);
        }
        return true;
    }

    private boolean confirmDeletePresentation() {
        int value = MessageDialog.showQuestion((Msg)CoreMsg.WARNING, (Msg)DesignerMsg.CONFIRM_PRESENTATION_DELETE, (int)6);
        return value == 2;
    }
}

