/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.OpenCloseMemberAccessorAction;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.ModifyAttributeAccessorAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class RemoveAttributeAccessorAction
extends ModifyAttributeAccessorAction {
    private final AttributeTypeDescription atd;

    public RemoveAttributeAccessorAction(@NotNull AttributeTypeDescription attribute, int accessorType) {
        super(UIMsg.MENU_DELETE, accessorType);
        this.requires(AttributeTypeDescription.class);
        this.atd = attribute;
    }

    @Override
    protected AttributeTypeDescription getAttribute() {
        return this.atd;
    }

    @Override
    protected SourceCode getCode() {
        return null;
    }

    @Override
    protected void updateAttribute() {
        this.closeAccessor();
        if (this.getAttribute().isVirtual()) {
            if (this.getAccessorType() == 8) {
                this.getAttribute().setHasGetter(false);
            } else {
                this.getAttribute().setHasSetter(false);
            }
        }
        CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)this.atd.getParent());
        FuegoObjectAction.storeObjectIfEditorIsNotActive(catalogObject);
    }

    protected void updateUI() {
    }

    private void closeAccessor() {
        MethodTypeDescription accessorMethod = OpenCloseMemberAccessorAction.methodFor(this.atd, this.getAccessorType());
        OpenCloseMemberAction.closeMember(accessorMethod);
    }
}

