/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.CustomFuegoAction;

public class ProjectToTemplateAction
extends CustomFuegoAction {
    public ProjectToTemplateAction() {
        super(DesignerMsg.CONVERT_TO_TEMPLATE);
        this.requires(Project.class);
    }

    public void run() {
        this.convert();
    }

    public boolean showsDialog() {
        return true;
    }

    private void convert() {
        Project project = (Project)this.getSelection().as(Project.class);
        assert (!project.isTemplate()) : "project already a template";
        ProjectPreferences preferences = project.getPreferences();
        preferences.setTemplate(true);
        try {
            project.getWriter().write(new ProjectObject[]{preferences});
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
    }
}

