/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.SingleProcessFilePreviewer;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.importer.CancelActionException;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.FileFilter;

public abstract class ProcessAction
extends DesignerAction {
    public ProcessAction(Msg msg) {
        super(msg);
        this.requires(Process.class);
    }

    public static File chooseFile(Process content, Msg msg) {
        FileFilter fileFilter = SchemaType.PROCESS.getFileFilter();
        FileChooser fc = ProcessAction.fileDialog(new FileFilter[]{fileFilter}, false);
        fc.setSelectedFile(new File(fc.getCurrentDirectory(), content.getId() + SchemaType.getExtensionFor(SchemaType.PROCESS)));
        int result = fc.showSaveDialog((UiComponent)Ui.getRoot(), msg);
        File file = null;
        if (result == 0) {
            file = ProcessAction.patchExtension(fc.getSelectedFile());
            CommonPreferences commonPreferences = CommonPreferences.getInstance();
            String absolutePath = file.getAbsolutePath();
            commonPreferences.setLastUsedFile(absolutePath);
            commonPreferences.updateMRUList(absolutePath);
        }
        return file;
    }

    public Process getProcess() {
        return (Process)this.getSelection().as(Process.class);
    }

    public FolderContainer selectContainer(Project project) throws CancelActionException {
        return new ProjectNavigatorBuilder((ProjectObject)project.getModelsRoot(), DesignerMsg.BROWSE_FOLDERS).include(FolderContainer.class).selectSingle(FolderContainer.class);
    }

    private static FileChooser fileDialog(FileFilter[] filters, boolean acceptAllFileFilter) {
        FileChooser fc = new FileChooser();
        fc.setName("process.chooser");
        SingleProcessFilePreviewer previewer = new SingleProcessFilePreviewer(Ui.getRoot(), fc);
        fc.setAccessory((UiComponent)previewer);
        for (FileFilter filter : filters) {
            fc.addChoosableFileFilter(filter);
        }
        fc.setAcceptAllFileFilterUsed(acceptAllFileFilter);
        if (filters.length > 0) {
            fc.setFileFilter(filters[0]);
        }
        return fc;
    }

    private static File patchExtension(File file) {
        String extensionFor = SchemaType.getExtensionFor(SchemaType.PROCESS);
        if (file.getPath().lastIndexOf(extensionFor) == -1) {
            String path = file.getPath();
            int index = path.lastIndexOf(".");
            if (index != -1) {
                path = path.substring(0, index);
            }
            return new File(path + extensionFor);
        }
        return file;
    }
}

