/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;

public abstract class OpenEditorAction
extends DesignerAction {
    protected static final int ATTRIBUTE_EDITOR_POSITION = 0;
    protected static final int CIL_EDITOR_POSTION = 1;
    protected static final int PRESENTATION_EDITOR_POSTION = 2;
    protected static final int TRANSFORMATION_EDITOR_POSTION = 3;
    public static final String CIL_EDITOR = "Editor";
    public static final String ATTRIBUTE_EDITOR = "Attribute";
    public static final String PRESENTATION_EDITOR = "Presentation";
    public static final String TRANSFORMATION_EDITOR = "Transformation";
    static final long serialVersionUID = 5224917016729000758L;
    static final long serialCheck = -1032535825943447235L;

    public OpenEditorAction(Msg msg) {
        super(msg);
    }

    protected String getEditorTitle(AbstractEditor parentEditor, AbstractEditor editorEditor) {
        String prefix = " ...";
        return prefix + editorEditor.getName();
    }

    protected final Image getIcon(String editorExtension) {
        Image icon = this.getIcon();
        if (icon == null && editorExtension != null) {
            if (editorExtension.equals(PRESENTATION_EDITOR)) {
                return Image.create((Msg)DesignerMsg.PRESENTATION);
            }
            if (editorExtension.equals(CIL_EDITOR)) {
                return Image.create((Msg)DesignerMsg.CILEDITOR);
            }
            if (editorExtension.equals(TRANSFORMATION_EDITOR)) {
                return Image.create((Msg)DesignerMsg.TRANSFORMATION);
            }
        }
        return icon;
    }

    protected Image getIcon() {
        return null;
    }

    protected String getPrefix(AbstractEditor parentEditor) {
        return parentEditor.getPanelId();
    }

    protected void openEditor(AbstractEditor parentEditor, StudioEditor editorEditor) {
        this.openEditor(parentEditor, editorEditor, CIL_EDITOR, 1);
    }

    protected void openEditor(AbstractEditor parentEditor, StudioEditor editorEditor, String editorName, int position) {
        StudioWorkbench workbench = this.getWorkbench();
        if (!workbench.isOpen(editorEditor)) {
            workbench.openEditor(editorEditor, parentEditor, position);
            if (editorEditor instanceof AbstractEditor) {
                ((AbstractEditor)editorEditor).setReadOnly(parentEditor.isReadOnly());
            }
        } else {
            workbench.refreshTitle(editorEditor);
            workbench.activateEditor(editorEditor);
            if (editorEditor instanceof AbstractEditor) {
                editorEditor.requestFocus();
            }
        }
    }
}

