/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationDialog;
import oracle.bpm.designer.variables.BusinessIndicatorDialogs;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class OpenDataObjectAction
extends DesignerAction {
    public OpenDataObjectAction() {
        this.requires(DataObject.class);
        this.setMsg(UIMsg.EDIT);
    }

    @Override
    public boolean doIt() {
        ProjectDataObject projectDataObject;
        DataObject dataObject = this.getDataObject();
        boolean isProjectDataObject = dataObject instanceof ProjectDataObject;
        if (isProjectDataObject && (projectDataObject = (ProjectDataObject)dataObject).isBusiness()) {
            return BusinessIndicatorDialogs.showForEditing(Ui.getRoot(), projectDataObject);
        }
        Msg msg = isProjectDataObject ? ProjectUiMsg.PROJECT_DATA_OBJECT : ProjectUiMsg.DATA_OBJECT;
        Msg titleMsg = ProjectUiMsg.EDIT((Msg)msg);
        DataDeclarationDialog dialog = new DataDeclarationDialog(Ui.getRoot(), (DataDeclaration)dataObject, dataObject.getDeclarationContainer().getLocalDeclarations(), titleMsg, msg);
        dialog.setVisible(true);
        if (dialog.userAccepted() && isProjectDataObject) {
            try {
                AbstractStudioWorkbench.storeProjectObjectIfNecessary((ProjectObject)dataObject.getProject().getProjectModel());
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
        return dialog.userAccepted();
    }

    private DataObject getDataObject() {
        return (DataObject)this.getSelection().as(DataObject.class);
    }
}

