/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioPreferencesDialog;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.formdesigner.PresentationDesignerPanel;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class OpenBPMPreferencesAction
extends DesignerAction {
    public OpenBPMPreferencesAction() {
        super(UIMsg.PREFERENCES);
        this.requires(Project.class);
    }

    @Override
    public void run() {
        this.optionsDialog();
    }

    private void optionsDialog() {
        StudioPreferencesDialog dialog = new StudioPreferencesDialog(Ui.getRoot());
        dialog.setVisible(true);
        this.updatePreferences();
    }

    private void updatePreferences() {
        StudioEditor[] editors;
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        for (StudioEditor e : editors = workbench.getEditors()) {
            AbstractEditor editor = (AbstractEditor)e;
            if (editor instanceof FuegoObjectAttributePropertiesPanel) {
                FuegoObjectAttributePropertiesPanel componentPanel = (FuegoObjectAttributePropertiesPanel)editor;
                componentPanel.checkLanguage();
                continue;
            }
            if (!(editor instanceof PresentationDesignerPanel)) continue;
            PresentationDesignerPanel presentationPanel = (PresentationDesignerPanel)editor;
            presentationPanel.refreshPresentation();
        }
    }
}

