/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.action.ChangeTargetForNoteAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

@ActionGroupMetadata(target=TextAnnotation.class)
public class NoteTargetFlowNodeAction
extends ActionGroup
implements ActionGroupFactory {
    public NoteTargetFlowNodeAction() {
        super(ProjectCommandMsg.CHANGE_TARGET);
        this.requires(TextAnnotation.class);
        this.setShowOnDisabled(false);
    }

    public ActionGroup create(Adaptable context) {
        NoteTargetFlowNodeAction group = new NoteTargetFlowNodeAction();
        group.build(context.as(TextAnnotation.class));
        return group;
    }

    private void build(@NotNull TextAnnotation note) {
        ActionGroup result;
        ActionGroup currentAction = result = new ActionGroup(ProjectCommandMsg.CHANGE_TARGET);
        int i = 0;
        FlowNode avoid = note.getTarget();
        NodeContainer container = note.getParentObject();
        if (avoid != null) {
            currentAction.add((BaseAction)new ChangeTargetForNoteAction());
        }
        for (FlowNode flowNode : container.getFlowNodes()) {
            if (flowNode.equals(avoid)) continue;
            if (i > 10) {
                ActionGroup moreActions = new ActionGroup(DesignerMsg.MORE);
                currentAction.addSeparator();
                currentAction.add((BaseAction)moreActions);
                currentAction = moreActions;
                i = 0;
            }
            currentAction.add((BaseAction)new ChangeTargetForNoteAction(flowNode));
            ++i;
        }
        this.add((BaseAction)result);
    }
}

