/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.DesignerDeleteAction;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.command.design.ChangeTargetForNoteCommand;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.LocalizedMessage;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;

public class NoteActions {
    private final NoteController controller;
    private ActionGroup noteActions;
    private TextAnnotation textAnnotation;

    public NoteActions(NoteController controller) {
        this.controller = controller;
        this.textAnnotation = (TextAnnotation)controller.getModelObject();
        this.noteActions = new ActionGroup(DesignerMsg.ROLE);
    }

    public ActionGroup buildActions() {
        ActionGroup result = this.getNoteActions();
        LocalizeAction localizedAction = new LocalizeAction();
        ActionGroup pointTo = new ActionGroup(DesignerMsg.POINT_TO);
        result.add((BaseAction)pointTo);
        this.buildPointToMenu(pointTo);
        result.add((BaseAction)localizedAction);
        result.addSeparator();
        result.add((BaseAction)DesignerDeleteAction.getInstance());
        result.setSelection(DefaultSelection.createSingle((Object)ModelObjectSelection.create((FlowElement[])new FlowElement[]{this.textAnnotation})));
        return result;
    }

    private void buildPointToMenu(ActionGroup menu) {
        TreeMap<String, FlowNode> sortedAct = new TreeMap<String, FlowNode>();
        Process model = this.textAnnotation.getProcess();
        Sequence flowNodeSequence = model.getDescendants(FlowNode.class);
        for (FlowNode flowNode : flowNodeSequence) {
            sortedAct.put(ModelUtils.getDuplicatedLabel((FlowNode)flowNode), flowNode);
        }
        menu.add((BaseAction)new PointToAction(null));
        Collection nodes = sortedAct.values();
        int i = 0;
        for (FlowNode node : nodes) {
            if (i > 10) {
                ActionGroup menu1 = new ActionGroup(DesignerMsg.MORE);
                menu.addSeparator();
                menu.add((BaseAction)menu1);
                menu = menu1;
                i = 0;
            }
            ++i;
            menu.add((BaseAction)new PointToAction(node));
        }
    }

    private ActionGroup getNoteActions() {
        return this.noteActions;
    }

    private class PointToAction
    extends DesignerAction {
        private final FlowNode node;

        public PointToAction(FlowNode node) {
            super(node == null ? DesignerMsg.NONE : UIMsg.TO_MSG((String)node.getLabelMap().getString()));
            this.node = node;
            this.requires(TextAnnotationImpl.class);
        }

        @Override
        public void run() {
            this.getRunner().run((Command)new ChangeTargetForNoteCommand(NoteActions.this.textAnnotation, this.node));
        }
    }

    private class LocalizeAction
    extends DesignerAction {
        public LocalizeAction() {
            super(DesignerMsg.LOCALIZED_MESSAGE);
            this.requires(TextAnnotationImpl.class);
        }

        @Override
        public void run() {
            NoteController noteController = NoteActions.this.controller;
            LocaleStringMap source = ((TextAnnotation)noteController.getModelObject()).getLabelMap();
            LocaleStringMap labelMap = source.clone();
            ProjectPreferences preferences = ((TextAnnotation)noteController.getModelObject()).getProject().getPreferences();
            List availableLanguages = preferences.getAvailableLanguages();
            LocalizedMessage.LocalizedDialog dialog = LocalizedMessage.createDialog((UiWindow)Ui.getRoot(), (LocaleStringMap)labelMap, (List)availableLanguages, (boolean)true);
            dialog.setTitle(LibMsg.NOTES.getString());
            dialog.setVisible(true);
            if (!dialog.userAccepted()) {
                return;
            }
            labelMap = dialog.getMessages();
            ((TextAnnotation)NoteActions.this.controller.getModelObject()).setLabelMap(labelMap);
        }
    }
}

