/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.OpenObjectPresentationAction;
import oracle.bpm.designer.formdesigner.PresentationCreation;
import oracle.bpm.designer.formdesigner.preferences.PresentationPreferencesPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.pref.Category;
import oracle.bpm.ui.pref.PreferencesDialog;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.XObjectFactory;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModelHelper;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class NewPresentationAction
extends FuegoObjectAction {
    private static NewPresentationAction instance;

    private NewPresentationAction() {
        super(DesignerMsg.ADD_PRESENTATION);
        this.requires(CatalogObject.class);
        this.setShowOnDisabled(false);
    }

    public static NewPresentationAction getInstance() {
        if (instance == null) {
            instance = new NewPresentationAction();
        }
        return instance;
    }

    @Override
    public void run() {
        this.newPresentation();
    }

    protected void setPresentable(final XObjectTypeDescription otd) {
        FuegoWorker.post((Runnable)new Runnable(){

            @Override
            public void run() {
                XObjectFactory.setXOPresentable(otd, true);
            }
        });
    }

    protected boolean storeInRepository(final XObjectTypeDescription otd) {
        boolean result = true;
        try {
            FuegoWorker.post((FuegoWorker.Procedure)new FuegoWorker.Procedure(){

                public void run() throws TypeCatalogException {
                    FuegoObjectAction.getTypeRepository(otd).update(otd);
                }
            });
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
            result = false;
        }
        return result;
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        CatalogObject catalogObject = (CatalogObject)selection.as(CatalogObject.class);
        ObjectTypeDescription objectType = catalogObject.getObjectType();
        this.setEnabled(this.isEditable(catalogObject) && !objectType.isInnerType());
    }

    private void newPresentation() {
        XObjectTypeDescription objectTypeDescription = (XObjectTypeDescription)this.getSelection().as(XObjectTypeDescription.class);
        if (objectTypeDescription != null) {
            WizardRunner runner = new WizardRunner(objectTypeDescription);
            runner.runWizard();
            if (!runner.wasWizardCanceled()) {
                if (!objectTypeDescription.isPresentable()) {
                    this.setPresentable(objectTypeDescription);
                }
                try {
                    XFormPresentationModel formPresentationModel = runner.createPresentation();
                    if (formPresentationModel != null) {
                        new OpenObjectPresentationAction(formPresentationModel, objectTypeDescription).doIt();
                        CatalogObject catalogObject = CatalogObjectImpl.create((Project)FuegoProject.getFrom((TypeRef)objectTypeDescription), (TypeRef)objectTypeDescription);
                    }
                }
                catch (ConstructionException e) {
                    MessageDialog.showError((Throwable)e);
                }
            }
        }
    }

    public static class WizardRunner {
        private XObjectTypeDescription objectTypeDescription;
        private PresentationGenerationOptions options;
        private PresentationCreation presentationWizard;

        public WizardRunner() {
            this(null);
        }

        public WizardRunner(XObjectTypeDescription objectTypeDescription) {
            this.objectTypeDescription = objectTypeDescription;
        }

        public void runWizard() {
            this.presentationWizard = new PresentationCreation(Ui.getRoot(), this.objectTypeDescription);
            Map properties = this.presentationWizard.getProperties();
            String oldColor = this.configurePresentationAddUseOptions(this.getOrLoadPresentationOptions());
            properties.put("color", oldColor);
            this.presentationWizard.run();
        }

        public boolean wasWizardCanceled() {
            return this.presentationWizard != null && this.presentationWizard.isCancelled();
        }

        public XFormPresentationModel createPresentation() throws ConstructionException {
            Map properties = this.presentationWizard.getProperties();
            String name = (String)properties.get("name");
            boolean fromTemplate = (Boolean)properties.get("fromTemplate");
            return this.createPresentation(this.objectTypeDescription, fromTemplate, properties, name, this.getOrLoadPresentationOptions());
        }

        private String configurePresentationAddUseOptions(final PresentationGenerationOptions options) {
            return (String)FuegoWorker.post((FuegoJob)new FuegoJob<String>(){

                public String run() {
                    boolean option = DesignerPreferences.getPreferences().isPresentationAddUseOptions();
                    return option ? options.getPresentationBackGround() : null;
                }
            });
        }

        private PresentationGenerationOptions getOrLoadPresentationOptions() {
            if (this.options == null) {
                this.options = (PresentationGenerationOptions)FuegoWorker.post((FuegoJob)new FuegoJob<PresentationGenerationOptions>(){

                    public PresentationGenerationOptions run() {
                        return PresentationGenerationOptions.load();
                    }
                });
            }
            return this.options;
        }

        private XFormPresentationModel createPresentation(XObjectTypeDescription otd, boolean fromTemplate, Map properties, String name, PresentationGenerationOptions options) throws ConstructionException {
            if (fromTemplate) {
                HashMap attributesmap = (HashMap)properties.get("attributesmap");
                if (attributesmap == null) {
                    attributesmap = new HashMap();
                }
                if (otd != null) {
                    return XObjectTypeDescriptionHelper.addPresentationModel((XObjectTypeDescription)otd, (String)name, (PresentationGenerationOptions)options, attributesmap);
                }
                XFormPresentationModel result = XFormPresentationModelHelper.generateDefaultPresentation(otd, name, options, attributesmap);
                XObjectTypeDescriptionHelper.ensureParents((XFormXMLObject)result);
                return result;
            }
            int rows = (Integer)properties.get("rows");
            int cols = (Integer)properties.get("cols");
            String color = (String)properties.get("color");
            if (otd != null) {
                return XObjectTypeDescriptionHelper.addPresentationModel((XObjectTypeDescription)otd, (String)name, (int)rows, (int)cols, (String)color);
            }
            XFormPresentationModel presentationModel = XObjectTypeDescriptionHelper.createPresentationModel((XObjectTypeDescription)otd, (String)name, (int)rows, (int)cols, (String)color);
            XObjectTypeDescriptionHelper.ensureParents((XFormXMLObject)presentationModel);
            return presentationModel;
        }
    }

    public static class PreferencesAction
    extends BaseAction {
        PresentationGenerationOptions options;
        Frame parentComponent;
        static final long serialVersionUID = -2690798970932628251L;
        static final long serialCheck = 5843422825254157123L;

        public PreferencesAction() {
            this(PresentationGenerationOptions.load());
        }

        public PreferencesAction(PresentationGenerationOptions options) {
            super(DesignerMsg.PRESENTATION_PREFERENCES);
            this.options = options;
        }

        public void setParentComponent(Frame c) {
            this.parentComponent = c;
        }

        public void run() {
            Category[] categories;
            PreferencesDialog preferencesDialog = new PreferencesDialog(Ui.getRoot(), DesignerMsg.PRESENTATION_PREFERENCES, true);
            PresentationPreferencesPanel p = new PresentationPreferencesPanel((UiContainer)preferencesDialog, this.options);
            for (Category category : categories = p.getCategories()) {
                preferencesDialog.addCategory(category);
            }
            preferencesDialog.pack();
            preferencesDialog.setLocationRelativeTo((UiComponent)this.parentComponent);
            preferencesDialog.setVisible(true);
        }
    }
}

