/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComponentBuilder;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;

public class NewPartnerElementAction
extends DesignerAction {
    static final long serialVersionUID = 7917265307003645631L;
    static final long serialCheck = 1680309087339500089L;

    public NewPartnerElementAction() {
        super(DesignerMsg.NEW_VAR);
    }

    @Override
    public boolean doIt() {
        NewPartnerBuilder componentBuilder = new NewPartnerBuilder();
        boolean ok = MessageDialog.showInput((UiWindow)Ui.getRoot(), (ComponentBuilder)componentBuilder, (Msg)CoreMsg.TYPE);
        if (ok) {
            ok = ((PartnerPanel)componentBuilder.getComponent()).createPartner();
        }
        return ok;
    }

    public void unDoIt() {
    }

    private static class PartnerPanel
    extends Panel {
        private oracle.bpm.ui.List<Msg> list;

        PartnerPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        public boolean createPartner() {
            Object value = this.list.getSelectedValue();
            if (DesignerMsg.PARTNER.equals(value)) {
                // empty if block
            }
            if (DesignerMsg.PARTNER_LINK.equals(value)) {
                // empty if block
            }
            return false;
        }

        private void init() {
            MsgList msgList = MsgList.create(DesignerMsg.PARTNER, DesignerMsg.PARTNER_LINK);
            this.list = oracle.bpm.ui.List.create((UiContainer)this, (List)msgList);
            this.list.setSelectedIndex(0);
            Dimension size = Dimension.valueOf(180, 70);
            this.list.setMinimumSize(size);
            this.list.setPreferredSize(size);
            this.list.setBorder(BorderFactory.createEtchedBorder());
            this.add((UiComponent)this.list);
        }
    }

    private static class NewPartnerBuilder
    implements ComponentBuilder {
        private PartnerPanel partnerPanel;

        private NewPartnerBuilder() {
        }

        public UiComponent getComponent() {
            return this.partnerPanel;
        }

        public UiComponent buildComponent(UiContainer parent) {
            this.partnerPanel = new PartnerPanel(parent);
            return this.getComponent();
        }
    }
}

