/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.process.wizard.NewBPMProcessWizard;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.Nullable;

public class NewModelAction
extends BaseAction {
    private boolean openEditor = true;
    private Process process;

    public NewModelAction() {
        super(SchemaType.PROCESS.getNewSchemaMsg());
        this.requires(ProjectObject.class);
        this.setOrder(ActionOrder.FIRST);
    }

    public void run() {
        FolderContainer folder = this.getModelContainer();
        if (folder != null) {
            NewBPMProcessWizard wizard = new NewBPMProcessWizard(folder.getProject(), folder);
            wizard.build();
            wizard.run();
            this.process = wizard.getProcess();
            if (!wizard.isCancelled() && this.openEditor) {
                new OpenObjectAction(wizard.getProcess()).run();
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean showsDialog() {
        return true;
    }

    public void setOpen(boolean b) {
        this.openEditor = b;
    }

    @Nullable
    private FolderContainer getModelContainer() {
        ProjectObject projectObject = (ProjectObject)this.getSelection().as(ProjectObject.class);
        return projectObject instanceof FolderContainer ? (FolderContainer)projectObject : projectObject.getProject().getModelsRoot();
    }
}

