/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.action.AddAttributeAccessorAction;
import oracle.bpm.designer.action.BPMObjectMethodInputValidator;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

public class NewMethodAction
extends FuegoObjectAction {
    private CatalogObject catalogModel;
    private CatalogMember newMethod;
    private CatalogType returnType;
    private CatalogObject type;
    static final long serialVersionUID = -7463146085991673445L;
    static final long serialCheck = 1905279850328866000L;

    public NewMethodAction(CatalogObject structure) {
        this(structure, CatalogType.Default.getVoid());
        this.setShowOnDisabled(false);
    }

    public NewMethodAction(CatalogObject structure, CatalogType returnType) {
        super(DesignerMsg.ADD_METHOD);
        this.requires(BpmObject.class);
        this.type = structure;
        this.catalogModel = structure;
        this.returnType = returnType;
    }

    @Override
    public boolean doIt() {
        return this.newMethod();
    }

    public void unDoIt() {
    }

    protected CatalogObject getCatalogModel() {
        return this.catalogModel;
    }

    protected CatalogMember getNewMethod() {
        return this.newMethod;
    }

    protected boolean newMethod() {
        boolean result;
        String name = MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.ADD_METHOD, (Msg)DesignerMsg.METHOD_NAME, (String)this.proposeName(this.type), (InputValidator)new BPMObjectMethodInputValidator(this.type.getObjectType()));
        if (name == null) {
            return false;
        }
        AccessorValidator av = new AccessorValidator(name, this.type.getObjectType());
        if (av.isAccessor()) {
            int dialgoResult = MessageDialog.showQuestion((UiContainer)null, (Msg)DesignerMsg.ADD_METHOD, (Msg)av.getMsg(), null, (int)9, null);
            result = dialgoResult == 1 && av.executeEditAccessor();
        } else {
            try {
                this.newMethod = (CatalogMember)FuegoWorker.post((FuegoWorker.Task)new AddMethodTask(name));
                AbstractStudioWorkbench.getInstance().openEditorForObject(this.newMethod);
                result = true;
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
                result = false;
            }
        }
        return result;
    }

    private String proposeName(CatalogObject obj) {
        String name;
        int counter = 1;
        while (obj.findMember(name = "method" + counter++) != null) {
        }
        return name;
    }

    private class AddMethodTask
    implements FuegoWorker.Task<CatalogMember> {
        private String name;

        AddMethodTask(String name) {
            this.name = name;
        }

        public CatalogMember run() throws ProjectException {
            return NewMethodAction.this.type.asBpmObject().newMethod(this.name, NewMethodAction.this.returnType);
        }
    }

    protected static class AccessorValidator {
        private MethodTypeDescription attribute;
        private String methodName;
        private ObjectTypeDescription object;
        private int part = -1;
        private static final String GET_PREFIX = "get";
        private static final String SET_PREFIX = "set";
        private static final String IS_PREFIX = "is";

        public AccessorValidator(String methodName, ObjectTypeDescription obj) {
            this.methodName = methodName;
            this.object = obj;
            this.doParse();
        }

        public boolean isAccessor() {
            return this.attribute != null;
        }

        public boolean executeEditAccessor() {
            boolean partialResult = true;
            if (!this.attributeHasPart()) {
                partialResult = new AddAttributeAccessorAction(this.attribute.asAttribute(), this.part).doIt();
            }
            if (partialResult) {
                OpenCloseMemberAction.openMember(this.attribute.asAttribute());
            }
            return partialResult;
        }

        protected Msg getMsg() {
            Msg msg = null;
            if (this.attribute != null) {
                String attributeName = this.attribute.getName();
                Msg msg2 = msg = this.part == 8 ? DesignerMsg.METHOD_IS_RESERVED_OPEN_READ(attributeName) : DesignerMsg.METHOD_IS_RESERVED_OPEN_WRITE(attributeName);
                if (!this.attributeHasPart()) {
                    msg = this.part == 8 ? DesignerMsg.METHOD_IS_RESERVED_OVERRIDE_READ(attributeName) : DesignerMsg.METHOD_IS_RESERVED_OVERRIDE_WRITE(attributeName);
                }
            }
            return msg;
        }

        private boolean attributeHasPart() {
            AttributeTypeDescription attributeTd = this.attribute.asAttribute();
            boolean result = this.part == 8 ? attributeTd.getCode() != null : (this.part == 7 ? attributeTd.getWriteCode() != null : false);
            return result;
        }

        private boolean isAccessor(String name) {
            int length = name.length();
            return (name.startsWith(GET_PREFIX) || name.startsWith(SET_PREFIX)) && length > 3 || name.startsWith(IS_PREFIX) && length > 2;
        }

        private MethodTypeDescription getAttribute(String accesorName) {
            int pos = accesorName.startsWith(IS_PREFIX) ? 2 : 3;
            String attributeName = Character.toLowerCase(accesorName.charAt(pos)) + accesorName.substring(pos + 1);
            MethodTypeDescription result = this.object.getMember(attributeName, 18);
            if (result == null) {
                attributeName = Character.toUpperCase(accesorName.charAt(pos)) + accesorName.substring(pos + 1);
                result = this.object.getMember(attributeName, 18);
            }
            return result;
        }

        private String generateSetterName(MethodTypeDescription attribute) {
            String attributeName = attribute.getName();
            return SET_PREFIX + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        }

        private String generateGetterName(MethodTypeDescription attribute) {
            String attributeName = attribute.getName();
            return (attribute.getResultType().isBool() ? IS_PREFIX : GET_PREFIX) + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        }

        private void doParse() {
            if (this.isAccessor(this.methodName)) {
                this.attribute = this.getAttribute(this.methodName);
                if (this.attribute != null) {
                    if (this.methodName.equals(this.generateGetterName(this.attribute))) {
                        this.part = 8;
                    } else if (this.methodName.equals(this.generateSetterName(this.attribute))) {
                        this.part = 7;
                    }
                }
            }
        }
    }
}

