/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.ObjectContainerDialog;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.Ui;

public class NewEnumerationAction
extends ModuleAction {
    private CatalogObject parent;
    private static final String ENUM_PREFIX = "Enum";

    public NewEnumerationAction() {
        this((CatalogObject)null);
    }

    public NewEnumerationAction(CatalogObject parent) {
        super(DesignerMsg.NEW_ENUMERATION);
        this.parent = parent;
        this.setExcludeDefault(true);
        this.setExcludeRoot(true);
        this.setShowOnDisabled(false);
    }

    @Override
    public void run() {
        this.newEnumeration();
    }

    private boolean newEnumeration() {
        ObjectContainerDialog dialog = new ObjectContainerDialog(Ui.getRoot(), DesignerMsg.NEW_ENUMERATION, DesignerMsg.ENUMERATION_MENU_ITEM, ENUM_PREFIX, this.parent);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            CatalogModule parent = dialog.getParentModule();
            String name = dialog.getObjectName();
            try {
                BpmObject enumType = parent.newEnum(name);
                parent.asMutable().addChild((ProjectObject)enumType);
                new OpenObjectAction(enumType).run();
            }
            catch (ProjectException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

