/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.argumentmapping.datadeclarations.DataDeclarationDialog;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.command.design.AddDataObjectCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.project.virtual.VirtualDataObjectsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class NewDataObjectAction
extends DesignerAction {
    private static final String DEFAULT_NAME = "dataObject";
    private static final String PROJECT_DEFAULT_NAME = "projectDataObject";

    public NewDataObjectAction() {
        this.requires(VirtualDataObjectsContainer.class);
        this.setMsg(UIMsg.NEW);
    }

    @Override
    public boolean doIt() {
        NodeContainer nodeContainer = this.getNodeContainer();
        boolean isProjectDataObject = ProcessContent.isDefaultProcess((NodeContainer)nodeContainer);
        String name = NewDataObjectAction.getDefaultDataObjectName(nodeContainer);
        DataObject dataObject = nodeContainer.createDataObject(name, CatalogType.Default.getString());
        Msg msg = isProjectDataObject ? ProjectUiMsg.PROJECT_DATA_OBJECT : ProjectUiMsg.DATA_OBJECT;
        Msg titleMsg = ProjectUiMsg.CREATE((Msg)msg);
        DataDeclarationContainer dataDeclarationContainer = (DataDeclarationContainer)nodeContainer;
        DataDeclarationDialog dialog = new DataDeclarationDialog(Ui.getRoot(), (DataDeclaration)dataObject, dataDeclarationContainer.getLocalDeclarations(), titleMsg, msg);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            try {
                ActionRunner.getInstance().run((Command)new AddDataObjectCommand(nodeContainer, dataObject));
                if (isProjectDataObject) {
                    AbstractStudioWorkbench.storeProjectObjectIfNecessary((ProjectObject)dataObject.getProject().getProjectModel());
                }
                return true;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProjectException) {
                    MessageDialog.showError((Msg)((ProjectException)e.getCause()).getMsg());
                }
                throw e;
            }
            catch (ProjectException e) {
                MessageDialog.showError((Msg)e.getMsg());
            }
        }
        return false;
    }

    private static String getDefaultDataObjectName(NodeContainer nodeContainer) {
        String varName;
        int count = 1;
        boolean isProjectDataObject = ProcessContent.isDefaultProcess((NodeContainer)nodeContainer);
        String string = varName = isProjectDataObject ? PROJECT_DEFAULT_NAME : DEFAULT_NAME;
        while (nodeContainer.findDataObject(varName + count) != null) {
            ++count;
        }
        return varName + count;
    }

    private NodeContainer getNodeContainer() {
        VirtualDataObjectsContainer virtualDataObjectsContainer = (VirtualDataObjectsContainer)this.getSelection().as(VirtualDataObjectsContainer.class);
        return (NodeContainer)virtualDataObjectsContainer.getRealParent();
    }
}

