/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.variables.BusinessIndicatorDialogs;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.virtual.VirtualBusinessIndicatorsContainer;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;

public class NewBusinessIndicatorAction
extends DesignerAction {
    private DataObject dataObject;
    private BusinessVariableType type;
    private static final String DEFAULT_NAME = "businessIndicator";

    private NewBusinessIndicatorAction(BusinessVariableType type) {
        this.requires(VirtualBusinessIndicatorsContainer.class);
        this.requires(ProcessContent.class);
        this.type = type;
        this.setMsg(UIMsg.NEW);
    }

    public static final NewBusinessIndicatorAction create() {
        return new NewBusinessIndicatorAction(BusinessVariableType.DIMENSION);
    }

    public static final NewBusinessIndicatorAction createForMeasurement() {
        return new NewBusinessIndicatorAction(BusinessVariableType.MEASURE);
    }

    public static final NewBusinessIndicatorAction createForCounter() {
        return new NewBusinessIndicatorAction(BusinessVariableType.COUNTER);
    }

    @Override
    public boolean doIt() {
        NodeContainer nodeContainer = this.getNodeContainer();
        String name = NewBusinessIndicatorAction.getDefaultDataObjectName(nodeContainer);
        ProjectDataObject newDataObject = (ProjectDataObject)nodeContainer.createDataObject(name, CatalogType.Default.getInt());
        newDataObject.setBusinessVariableType(this.type);
        if (BusinessIndicatorDialogs.showForCreation(Ui.getRoot(), newDataObject, this.type)) {
            this.dataObject = newDataObject;
            return true;
        }
        return false;
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    private static String getDefaultDataObjectName(NodeContainer nodeContainer) {
        int count = 1;
        String name = DEFAULT_NAME;
        while (nodeContainer.findDataObject(DEFAULT_NAME + count) != null) {
            ++count;
        }
        return DEFAULT_NAME + count;
    }

    private NodeContainer getNodeContainer() {
        return this.getSelection().as(NodeContainer.class) != null ? (NodeContainer)this.getSelection().as(NodeContainer.class) : (NodeContainer)((VirtualBusinessIndicatorsContainer)this.getSelection().as(VirtualBusinessIndicatorsContainer.class)).getRealParent();
    }
}

