/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.DetailedCILTypeComboBox;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.WindowAdapter;
import oracle.bpm.ui.event.WindowEvent;
import oracle.bpm.ui.event.WindowListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

public class NewAttributeDialog
extends OkCancelDialog {
    private IdentifierTextField name;
    private boolean primitivesOnly;
    private ComponentCatalog repository;
    private TypeChooserPanel typeChooserPanel;

    private NewAttributeDialog(UiWindow parent, ComponentCatalog componentCatalog, String initialText, boolean open, boolean primitivesOnly) {
        super(parent, ProjectUiMsg.CREATE((Msg)DesignerMsg.STD_ATTRIBUTE));
        this.setTypeRepository(componentCatalog);
        this.init(parent, primitivesOnly, initialText, open);
    }

    public static NewAttributeDialog createDefaultPrimitiveDialog(UiWindow parent, ComponentCatalog componentCatalog, String varName) {
        return new NewAttributeDialog(parent, componentCatalog, varName, false, true);
    }

    public static NewAttributeDialog createPrimitiveDialog(UiWindow parent, ComponentCatalog componentCatalog, String varName, boolean open) {
        return new NewAttributeDialog(parent, componentCatalog, varName, open, false);
    }

    public String getAttributeName() {
        return this.name.getText();
    }

    public String getSelectedTypeAsString() {
        CatalogType typeRef = this.typeChooserPanel.getEnsuredSelectedItem();
        return typeRef == null ? "" : typeRef.getText();
    }

    public void setType(CatalogType typeRef) {
        this.typeChooserPanel.setInitialType(typeRef, false);
    }

    public CatalogType getTypeRef() throws IllegalTypeException {
        CatalogType type = this.typeChooserPanel.getEnsuredSelectedItem();
        if (type == null) {
            throw new IllegalTypeException(this.getSelectedTypeAsString());
        }
        return type;
    }

    public void setTypeRepository(ComponentCatalog repository) {
        this.repository = repository;
    }

    public ComponentCatalog getTypeRepository() {
        return this.repository;
    }

    public void cancel() {
        this.setUserAccepted(false);
        this.setVisible(false);
        this.dispose();
    }

    public void ok() {
        this.setUserAccepted(true);
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setUserAccepted(false);
        }
        super.setVisible(visible);
    }

    public boolean shouldOpenAttribute() {
        return false;
    }

    protected DetailedCILTypeComboBox buildTypesCombo(Panel container, ComponentCatalog repository) {
        return new DetailedCILTypeComboBox((UiContainer)container, repository);
    }

    private void init(UiWindow parent, boolean primitivesOnly, String initialText, boolean open) {
        this.primitivesOnly = primitivesOnly;
        this.initGui(initialText, open);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo((UiComponent)parent);
    }

    private void initGui(String initialText, boolean open) {
        Panel panel = new Panel(this.getContentPane());
        FormLayout layout = new FormLayout("5dlu,pref,5dlu,fill:pref:grow,5dlu", "5dlu,pref,5dlu,pref,5dlu");
        panel.setLayout((Layout)layout);
        Label idLabel = Label.create((UiContainer)panel, (Msg)ProjectDrawMsg.NAME);
        this.name = new IdentifierTextField((UiContainer)panel, initialText, 35, false, false);
        this.name.setSelectionStart(0);
        this.name.setSelectionEnd(this.name.getText().length());
        Label typeLabel = Label.create((UiContainer)panel, (Msg)CoreMsg.TYPE);
        ComponentCatalog catalog = this.getTypeRepository();
        assert (catalog != null) : "Must set a DefaultComponentCatalog first";
        this.typeChooserPanel = TypeChooserPanel.create((UiContainer)panel, catalog, ProjectFilters.NON_WSDL_OBJECTS);
        CellConstraints cc = new CellConstraints();
        panel.add((UiComponent)idLabel, (Object)cc.xy(2, 2));
        panel.add((UiComponent)this.name, (Object)cc.xy(4, 2));
        panel.add((UiComponent)typeLabel, (Object)cc.xy(2, 4));
        panel.add((UiComponent)this.typeChooserPanel, (Object)cc.xy(4, 4));
        this.getContentPane().add((UiComponent)panel);
        this.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NewAttributeDialog.this.cancel();
            }
        });
        this.name.grabFocus();
    }
}

