/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.action.BPMObjectAttributeInputValidator;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.NewAttributeDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;

public class NewAttributeAction
extends FuegoObjectAction {
    private boolean doOpen;

    public NewAttributeAction(CatalogObject catalogObject) {
        this(catalogObject, DesignerPreferences.getPreferences().getOpenMemberEditor());
        this.setShowOnDisabled(false);
    }

    public NewAttributeAction(CatalogObject catalogObject, boolean doOpen) {
        super(DesignerMsg.STD_ATTRIBUTE);
        this.requires(BpmObject.class);
        this.setSelection(DefaultSelection.createSingle((Object)catalogObject));
        this.doOpen = doOpen;
    }

    public static void silentCreate(BpmObject catalogObject) {
        new NewAttributeAction((CatalogObject)catalogObject, false).run();
    }

    @Override
    public void run() {
        this.setSuccess(this.newAttribute());
    }

    @Override
    protected void updateEnableStatus(Selection sel) {
        this.setEnabled(((BpmObject)sel.as(BpmObject.class)).canAddAttributes());
    }

    private String getDefaultName(CatalogObject catalogObject) {
        String name;
        ObjectTypeDescription objectType = catalogObject.getObjectType();
        int counter = 1;
        while (!BpmObjectTypeDescriptionHelper.isValidAttName((ObjectTypeDescription)objectType, (String)(name = "attribute" + counter++)) || objectType.findMember(name) != null) {
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean newAttribute() {
        CatalogMember member;
        boolean invalidType;
        BpmObject catalogObject = (BpmObject)this.getSelection().as(BpmObject.class);
        String name = this.getDefaultName((CatalogObject)catalogObject);
        CatalogType type = CatalogType.Default.getString();
        NewAttributeDialog dialog = NewAttributeDialog.createPrimitiveDialog(Ui.getRoot(), NewAttributeAction.getTypeRepository((CatalogObject)catalogObject), name, this.doOpen);
        dialog.makeRecyclable();
        BPMObjectAttributeInputValidator attributeInputValidator = new BPMObjectAttributeInputValidator((CatalogObject)catalogObject);
        boolean isValidName = false;
        do {
            dialog.setVisible(true);
            if (!dialog.userAccepted()) {
                return false;
            }
            name = dialog.getAttributeName();
            try {
                type = dialog.getTypeRef();
                invalidType = false;
            }
            catch (IllegalTypeException e1) {
                MessageDialog.showError((Msg)DesignerMsg.ERROR, (Msg)DesignerMsg.INVALID_TYPE(dialog.getSelectedTypeAsString()), (Throwable)e1);
                invalidType = true;
                dialog.setType(type);
            }
            if (invalidType) continue;
            try {
                attributeInputValidator.validate(name);
                isValidName = true;
            }
            catch (InputValidationException e) {
                MessageDialog.showError((Msg)DesignerMsg.ATTRIBUTE_NAME, (Msg)e.getKey());
                isValidName = false;
            }
        } while (!isValidName || invalidType);
        Transactable transactable = (Transactable)catalogObject;
        try {
            transactable.beginTransaction();
            member = catalogObject.createAttribute(name, type);
            catalogObject.addChild((ProjectObject)member);
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            transactable.endTransaction();
        }
        boolean shouldOpenAttribute = dialog.shouldOpenAttribute();
        dialog.dispose();
        this.openOrStoreEditor(shouldOpenAttribute, member, catalogObject);
        return true;
    }

    private void openOrStoreEditor(boolean shouldOpenAttribute, CatalogMember member, BpmObject catalogObject) {
        if (shouldOpenAttribute) {
            AbstractStudioWorkbench.getInstance().openEditorForObject(catalogObject, member);
            ObjectTypeDescription parentType = catalogObject.getObjectType();
            parentType.setModifiers(parentType.getModifiers());
        } else {
            FuegoObjectAction.storeObjectIfEditorIsNotActive((CatalogObject)catalogObject);
        }
        if (shouldOpenAttribute != this.doOpen) {
            DesignerPreferences.getPreferences().setOpenMemberEditor(shouldOpenAttribute);
            DesignerPreferences.getPreferences().store();
        }
    }
}

