/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;

public class MultipleAction
extends DesignerAction {
    private List<BaseAction> actions = new ArrayList<BaseAction>();
    private ProjectNavigatorTree navigatorTree;
    static final long serialVersionUID = 6978603566482278480L;
    static final long serialCheck = -6898023504943585685L;

    public MultipleAction(ProjectNavigatorTree navigatorTree) {
        super(null);
        this.navigatorTree = navigatorTree;
    }

    public MultipleAction(ProjectNavigatorTree navigatorTree, BaseAction[] actions) {
        super(actions[0].getMsg());
        for (BaseAction action : actions) {
            this.actions.add(action);
        }
        this.navigatorTree = navigatorTree;
    }

    public void addAction(BaseAction action) {
        if (this.getMsg() == null) {
            this.setMsg(action.getMsg());
        }
        this.actions.add(action);
    }

    @Override
    public boolean doIt() {
        if (!UiUtilities.isEventDispatchThread()) {
            this.doInvoke();
        } else {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MultipleAction.this.doInvoke();
                }
            });
        }
        return true;
    }

    public void unDoIt() {
    }

    protected BaseAction[] getActions() {
        return this.actions.toArray(new BaseAction[0]);
    }

    private void doInvoke() {
        for (BaseAction baseAction : this.actions) {
            baseAction.actionPerformed(new ActionEvent((Object)this.navigatorTree, baseAction.getMsg().toString()));
        }
    }
}

