/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ProcessEditor;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.action.ProcessPropertiesAction;
import oracle.bpm.designer.action.ShowConditionalTransitionsAction;
import oracle.bpm.designer.action.ShowDueTransitionsAction;
import oracle.bpm.designer.action.ShowExceptionsAction;
import oracle.bpm.designer.action.ShowGrabAction;
import oracle.bpm.designer.action.ShowGrabTransitionsAction;
import oracle.bpm.designer.action.ShowMeasurementMarksAction;
import oracle.bpm.designer.action.ShowNotesAction;
import oracle.bpm.designer.action.ShowUnconditionalTransitionsAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.simulation.NewModelSimulationAction;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

public class ModelActions {
    public static BaseAction showGrabAction = new ShowGrabAction();
    public static BaseAction showNotesAction = new ShowNotesAction();
    public static ShowMeasurementMarksAction showMeasurementMarksAction = new ShowMeasurementMarksAction();
    public static BaseAction showGrabTransitionsAction = new ShowGrabTransitionsAction();
    public static BaseAction showUnconditionalTransitionsAction = new ShowUnconditionalTransitionsAction();
    public static BaseAction showConditionalTransitionsAction = new ShowConditionalTransitionsAction();
    public static BaseAction showDueTransitionsAction = new ShowDueTransitionsAction();
    public static BaseAction showExceptionsAction = new ShowExceptionsAction();
    private static ModelActions instance;

    private ModelActions() {
    }

    public static void create() {
        if (instance == null) {
            instance = new ModelActions();
        }
    }

    public static ModelActions getInstance() {
        if (instance == null) {
            ModelActions.create();
        }
        return instance;
    }

    public static ActionGroup getActionGroup(Process model) {
        boolean isProcess;
        ProcessEditor[] editors;
        ActionGroup result = new ActionGroup(DesignerMsg.EDIT, DesignerMode.getCurrentMode().getActionValidator());
        for (ProcessEditor editor : editors = (ProcessEditor[])AbstractStudioWorkbench.getInstance().getEditorsByClass(ProcessEditor.class)) {
            ProcessPanel panel = editor.getProcessPanel();
            if (panel != null && panel.getModel() != null && panel.getModel() != model) continue;
        }
        result.add((BaseAction)ProcessPropertiesAction.getInstance());
        boolean isInterface = false;
        SchemaType type = SchemaType.PROCESS;
        boolean bl = isProcess = type.isProcess() && !isInterface;
        if (isProcess) {
            result.addSeparator();
            result.add((BaseAction)new NewModelSimulationAction(model, model.getProject()));
            result.addSeparator();
        }
        return result;
    }

    public static LayoutModelCommand getLayoutCommand(Process model, boolean interactive) {
        LayoutModelCommand result = null;
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        if (ModelUtils.isHorizontal((Process)model) && (preferences.isAutoLayout() || !interactive)) {
            result = preferences.getSnapToGrid() ? new LayoutModelCommand(model, new Grid(preferences.getGridSize()), preferences.isOptimizeLanesOnAutoLayout()) : new LayoutModelCommand(model, preferences.isOptimizeLanesOnAutoLayout());
        }
        return result;
    }
}

