/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.GridPropertiesDialog;
import oracle.bpm.designer.action.BaseActionSet;
import oracle.bpm.designer.action.ImportProcessesAction;
import oracle.bpm.designer.action.ModelActions;
import oracle.bpm.designer.action.NewModelAction;
import oracle.bpm.designer.action.NewModelContainerAction;
import oracle.bpm.designer.action.ProcessPropertiesAction;
import oracle.bpm.designer.action.ShowActivityLabelActionGroup;
import oracle.bpm.designer.action.ShowGridAction;
import oracle.bpm.designer.action.ShowTransitionLabelActionGroup;
import oracle.bpm.designer.action.SnapToGridAction;
import oracle.bpm.designer.action.ThemesActionGroup;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.ActivityTitle;
import oracle.bpm.draw.TransitionMessageType;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.ActionStyle;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

public class ModelActionSet
extends BaseActionSet {
    private static ModelActionSet instance = new ModelActionSet();
    private static BaseAction[] actions;
    public static BaseAction showGridAction;
    public static BaseAction newProcessAction;
    public static BaseAction newFolderAction;
    public static BaseAction newProcedureAction;
    public static BaseAction newScreenflowAction;
    public static BaseAction generateProcessReportAction;
    public static BaseAction genProcessInterfaceAction_d;
    public static BaseAction importProcessesAction;
    public static BaseAction createSubAction;
    public static BaseAction checkDesignAction;
    public static BaseAction processInfoAction;
    public static BaseAction publishProcessAction_d;
    public static BaseAction webServicesAction_d;

    private ModelActionSet() {
        processInfoAction = ProcessPropertiesAction.getInstance();
        actions = new BaseAction[]{processInfoAction, importProcessesAction = new ImportProcessesAction(), newFolderAction = new NewModelContainerAction(), newProcessAction = new NewModelAction()};
    }

    public static ModelActionSet get() {
        ModelActionSet.create();
        return instance;
    }

    public static BaseAction[] getActions() {
        ModelActionSet.get();
        return actions;
    }

    @Override
    public ActionGroup getDefaultMenuActions(Object arg) {
        assert (arg == null || arg instanceof Process) : "Invalid process: " + arg;
        Process process = (Process)arg;
        return ModelActions.getActionGroup(process);
    }

    @Override
    public ActionGroup getViewMenuActions(Object arg) {
        Process process = (Process)arg;
        ActionGroup result = new ActionGroup(null);
        result.setInline(true);
        ActionGroup activityActions = new ActionGroup(ProjectMsg.ACTIVITIES);
        activityActions.add((BaseAction)new ShowActivityLabelActionGroup(ActivityTitle.values()));
        result.add((BaseAction)activityActions);
        result.addSeparator();
        ActionGroup transitionActions = new ActionGroup(DesignerMsg.TRANSITIONS);
        transitionActions.add((BaseAction)new ShowTransitionLabelActionGroup(TransitionMessageType.values()));
        result.add((BaseAction)transitionActions);
        result.addSeparator();
        ActionGroup themeActions = ModelActionSet.createThemeActions();
        result.add((BaseAction)themeActions);
        result.addSeparator();
        ActionGroup gridActions = new ActionGroup(DesignerMsg.GRID);
        result.add((BaseAction)gridActions);
        result.addSeparator();
        SnapToGridAction toGridAction = SnapToGridAction.getInstance();
        toGridAction.setStyle(ActionStyle.CHECK);
        gridActions.add((BaseAction)toGridAction);
        ShowGridAction showGrid = ShowGridAction.getInstance();
        showGrid.setStyle(ActionStyle.CHECK);
        gridActions.add((BaseAction)showGrid);
        gridActions.add((BaseAction)new GridSetupAction());
        return result;
    }

    @Override
    public void updateSharedActions(Object arg) {
    }

    @Override
    public void updateSharedMenus(Object arg) {
    }

    @Override
    protected void registerSharedActions(BaseActionSet.ActionsMap actionsMap) {
    }

    private static void create() {
        if (instance == null) {
            instance = new ModelActionSet();
        }
    }

    private static ActionGroup createThemeActions() {
        return new ThemesActionGroup(DefaultTheme.getThemes());
    }

    public static final class GridSetupAction
    extends BaseAction {
        private GridSetupAction() {
            super(DesignerMsg.SETUP);
            this.requires(Void.class);
        }

        public void run() {
            GridPropertiesDialog dialog = new GridPropertiesDialog(Ui.getRoot());
            dialog.setVisible(true);
            boolean snap = DesignerPreferences.getPreferences().getSnapToGrid();
            if (snap) {
                SnapToGridAction.snapToGrid();
            }
        }
    }
}

