/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.OpenComponentAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class MigrateLegacyXOAction
extends FuegoObjectAction {
    private TypeRef typeRef;
    static final long serialVersionUID = 1731704681020726234L;
    static final long serialCheck = -7824150650130515221L;

    public MigrateLegacyXOAction(TypeRef type) {
        super(DesignerMsg.MIGRATE_LEGACY_XO);
        this.typeRef = type.getRef();
    }

    public static boolean mustEnableFor(ObjectTypeDescription objectType) {
        return objectType.isBpmObject() && XObjectTypeDescriptionHelper.isLegacyXO((ObjectTypeDescription)objectType);
    }

    @Override
    public boolean doIt() {
        if (!(this.getObject() instanceof XObjectTypeDescription)) {
            return false;
        }
        XObjectTypeDescription xotd = (XObjectTypeDescription)this.getObject();
        if (!XObjectTypeDescriptionHelper.isLegacyXO((ObjectTypeDescription)xotd)) {
            return false;
        }
        OpenComponentAction oca = new OpenComponentAction(xotd);
        oca.run();
        if (!oca.isSuccess()) {
            return false;
        }
        try {
            XObjectTypeDescriptionHelper.legacyXOMigration((XObjectTypeDescription)xotd);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        return true;
    }

    public void unDoIt() {
    }

    @Override
    protected void updateEnableStatus(Selection selection) {
        CatalogObject catalogObject = (CatalogObject)selection.as(CatalogObject.class);
        ObjectTypeDescription objectType = catalogObject.getObjectType();
        this.setEnabled(this.isEditable(catalogObject) && !objectType.isInnerType() && MigrateLegacyXOAction.mustEnableFor(objectType));
    }

    private ObjectTypeDescription getObject() {
        return this.typeRef.get().asObject();
    }
}

