/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.features.ModelNameFeature;
import oracle.bpm.project.model.features.RelatedBPMNProcessFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public class LoadSubflowAction
extends BaseAction {
    private final ActivityController controller;

    public LoadSubflowAction(ActivityController controller) {
        super(ProjectMsg.SUBFLOW);
        this.requires(FlowNode.class);
        this.controller = controller;
    }

    public void run() {
        this.loadSubflow();
    }

    protected void updateEnableStatus(Selection selection) {
        FlowNode node = (FlowNode)this.getSelection().as(FlowNode.class);
        RelatedBPMNProcessFeature ipcFeature = (RelatedBPMNProcessFeature)node.getFeature(RelatedBPMNProcessFeature.class);
        ModelNameFeature relatedProcess = ipcFeature.getTargetModelName();
        Process process = node.getProject().findProcess(relatedProcess.getName());
        if (process != null) {
            this.setEnabled(true);
            this.setMsg(DesignerMsg.EMPTY_MSG(ProjectMsg.SUBFLOW.getString() + " " + process.getId()));
        } else {
            this.setMsg(ProjectMsg.SUBFLOW);
            this.setEnabled(false);
        }
    }

    private void loadSubflow() {
        FlowNode node = (FlowNode)this.controller.getModelObject();
        if (ModelUtils.isCallActivity((FlowNode)node)) {
            RelatedBPMNProcessFeature ipcFeature = (RelatedBPMNProcessFeature)node.getFeature(RelatedBPMNProcessFeature.class);
            ModelNameFeature relatedProcess = ipcFeature.getTargetModelName();
            Process process = node.getProject().findProcess(relatedProcess.getName());
            if (process != null) {
                new OpenObjectAction(process).run();
            }
        }
    }
}

