/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import fuego.prefs.engine.standalone.studio.StudioNetworkingPreferences;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.action.AbstractWebAppLauncherAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.deployment.Engine;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;

public class LaunchPAPIWSAction
extends AbstractWebAppLauncherAction
implements SelectionListener {
    private ProjectListener<Engine> engineListener;
    private Project projectSelected;
    private RepositoryListener repositoryListener;

    public LaunchPAPIWSAction() {
        super(DesignerMsg.LAUNCH_PAPI_WS);
        SelectionProvider selectionProvider = AbstractStudioWorkbench.getInstance().getSelectionProvider();
        selectionProvider.addSelectionListener((SelectionListener)this);
        this.registerRepositoryListener();
    }

    public void selectionChanged(Selection selection) {
        Project project = (Project)selection.as(Project.class);
        if (project != null && project.isOpen()) {
            this.updateEngineListener(project);
        }
    }

    @Override
    protected boolean isEnabledFor(Selection selection) {
        boolean enabled = super.isEnabledFor(selection);
        if (enabled) {
            Project project = (Project)selection.as(Project.class);
            enabled = AbstractStudioWorkbench.getInstance().getRepository().isOpen(project);
            if (enabled) {
                StudioNetworkingPreferences networkingPreferences = this.getNetworkingPreferences(project);
                enabled = networkingPreferences.getStartPapiWs().getValue();
            }
        }
        return enabled;
    }

    @Override
    protected String getWebAppUrl(Project project) {
        return this.getNetworkingPreferences(project).getPapiWsUrl().getValue();
    }

    private void updateEngineListener(Project project) {
        if (this.projectSelected != project) {
            if (this.engineListener != null) {
                this.removeEngineListener();
            }
            this.engineListener = new ProjectListenerAdapter<Engine>(Engine.class){

                public void objectChanged(Engine engine, ProjectEvent event) {
                    LaunchPAPIWSAction.this.setEnabled(LaunchPAPIWSAction.this.getNetworkingPreferences(engine.getProject()).getStartPapiWs().getValue());
                }
            };
            this.addEngineListener(project);
        }
    }

    private void registerRepositoryListener() {
        if (this.repositoryListener == null) {
            this.repositoryListener = new RepositoryAdapter(){

                public void preProjectClose(Project project) {
                    LaunchPAPIWSAction.this.removeEngineListener();
                }

                public void projectOpened(Project project) {
                    LaunchPAPIWSAction.this.updateEngineListener(project);
                }
            };
            ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
            repository.addRepositoryListener(this.repositoryListener);
        }
    }

    private void removeEngineListener() {
        this.projectSelected.removeListener(this.engineListener);
        this.projectSelected = null;
        this.engineListener = null;
    }

    private void addEngineListener(Project project) {
        this.projectSelected = project;
        this.projectSelected.addListener(this.engineListener);
    }

    private StudioNetworkingPreferences getNetworkingPreferences(Project project) {
        return (StudioNetworkingPreferences)project.getDeployment().getEngine().getEnginePreferences().getNetworking();
    }
}

