/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.action.SaveAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.ui.UiUtilities;

public class InternalAutoSaveAction
extends DesignerAction {
    private StudioEditor editor;
    static final long serialVersionUID = -4134790300006672083L;
    static final long serialCheck = -3850700885532740999L;

    public InternalAutoSaveAction() {
        super(DesignerMsg.AUTO_SAVE);
    }

    public InternalAutoSaveAction(StudioEditor editor) {
        super(DesignerMsg.AUTO_SAVE);
        this.editor = editor;
    }

    @Override
    public boolean doIt() {
        return this.autoSave();
    }

    public void unDoIt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean autoSave() {
        block5: {
            if (!DesignerApplication.hasInstance()) {
                return true;
            }
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    DesignerApplication instance = DesignerApplication.getInstance();
                    instance.getStatusBar().showNotice(DesignerMsg.SAVING);
                    instance.enableUserInput(false);
                }
            });
            if (this.editor == null) break block5;
            this.savePanel(this.editor);
            boolean bl = true;
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    DesignerApplication.getInstance().enableUserInput(true);
                    DesignerApplication.getInstance().getStatusBar().clearMessage();
                }
            });
            return bl;
        }
        try {
            AbstractEditor[] openedPanels;
            for (AbstractEditor openedEditor : openedPanels = Context.getOpenedPanels()) {
                this.savePanel(openedEditor);
            }
        }
        catch (Throwable throwable) {
            UiUtilities.invokeLater((Runnable)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        UiUtilities.invokeLater((Runnable)new /* invalid duplicate definition of identical inner class */);
        return true;
    }

    private void savePanel(final StudioEditor openedEditor) {
        if (openedEditor.isDirty()) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    new SaveAction(openedEditor).doIt();
                }
            });
        }
    }
}

