/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.designer.action.DeleteCatalogNodeAction;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.FileFilter;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.ImportOTDWrapper;

public class ImportObjectAction
extends ModuleAction {
    private ErrorManager errorManager;
    private int importType;
    private Map<String, ObjectTypeDescription> objectMap;
    private TypeRef parentNode = null;
    private boolean requiresModuleSelection = true;
    private static final int FUEGO_OBJECT = 0;
    private static final int ENUM = 1;

    private ImportObjectAction(int importType) {
        super(ImportObjectAction.getMsg(importType));
        this.importType = importType;
        this.errorManager = new ErrorManager();
        this.setExcludeRoot(true);
        this.setExcludeDefault(true);
    }

    private ImportObjectAction(CatalogObject object, int importType) {
        this(importType);
        this.setShowOnDisabled(false);
        this.parentNode = object != null ? object.getObjectType() : null;
        this.requiresModuleSelection = this.parentNode == null;
    }

    public static ImportObjectAction getImportEnumerationAction() {
        return new ImportObjectAction(1);
    }

    public static ImportObjectAction getImportEnumerationAction(CatalogObject parentNode) {
        return new ImportObjectAction(parentNode, 1);
    }

    public static ImportObjectAction getImportFuegoObjectAction() {
        return new ImportObjectAction(0);
    }

    public static ImportObjectAction getImportFuegoObjectAction(CatalogObject parentNode) {
        return new ImportObjectAction(parentNode, 0);
    }

    @Override
    public void run() {
        boolean mustImport;
        this.errorManager.reset();
        File[] files = this.selectFilesToImport();
        boolean bl = mustImport = files != null && files.length != 0 && this.hasParentNode(files);
        if (mustImport) {
            boolean successful = this.loadToMap(files);
            if (!successful) {
                this.errorManager.displayResults();
            } else {
                boolean overwrite = this.selectOverwriteCriteria();
                this.loadObjects(overwrite);
            }
        }
    }

    public void unDoIt() {
    }

    private static Msg getMsg(int importType) {
        if (importType == 0) {
            return BpmObjectMsg.BPM_OBJECT;
        }
        return DesignerMsg.ENUMERATION_MENU_ITEM;
    }

    private FileChooser buildFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.setName("import.object");
        FileFilter filter = FileFilter.create(this.importType == 1 ? UIMsg.EXPORTED_ENUM_FILES : UIMsg.EXPORTED_FOBJECT_FILES, ".xml", ".xcdl", ".zip", ".jar");
        chooser.setFileFilter(filter);
        return chooser;
    }

    private boolean selectOverwriteCriteria() {
        boolean confirm;
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        Msg titleMsg = DesignerMsg.OVERWRITE_FILES;
        Msg confirmMsg = DesignerMsg.CONFIRM_OVERWRITE_FILES;
        boolean oldValue = Boolean.valueOf(preferences.getMessageValue(confirmMsg.getCode()));
        if (oldValue != (confirm = DialogFactory.showConfirmDialog((HiddenMessagesPreferences)preferences, (Msg)titleMsg, (Msg)confirmMsg))) {
            preferences.store();
        }
        return confirm;
    }

    private void checkUnknownInnerObjects(ObjectTypeDescription obj) {
        int i;
        for (i = 0; i < obj.getMemberCount(); ++i) {
            boolean typeFound;
            MethodTypeDescription eachMember = obj.getMemberType(i);
            if (!eachMember.isAttribute()) continue;
            TypeDescription type = eachMember.getResultType();
            if (type.isArray()) {
                type = type.getElementType();
            }
            if (type.isPredefined()) continue;
            try {
                ComponentCatalog repository = type.getCatalog();
                typeFound = repository != null && repository.find(type.getText()) != null;
            }
            catch (AmbiguousTypeNameException e) {
                typeFound = false;
            }
            if (typeFound) continue;
            this.errorManager.reportWarning(DesignerMsg.IMPORT_ATTRIBUTE_TYPE_NOT_FOUND(obj.getMember(i).getName(), obj.getName(), type.getText()).toString());
        }
        for (i = 0; i < obj.getInnerTypeCount(); ++i) {
            this.checkUnknownInnerObjects(obj.getInnerType(i));
        }
    }

    private void doAdd(ObjectTypeDescription parent, ObjectTypeDescription obj) {
        MutableComponentCatalog catalogRepository = (MutableComponentCatalog)obj.getCatalog();
        parent.addInnerType(obj);
        try {
            catalogRepository.add(obj);
        }
        catch (TypeCatalogException e) {
            this.errorManager.reportError(DesignerMsg.IMPORT_ERROR(e.toString()));
        }
        if (obj.isBpmObject()) {
            this.checkUnknownInnerObjects(obj);
        }
    }

    private boolean hasParentNode(File[] files) {
        if (this.requiresModuleSelection(files)) {
            CatalogModule module = ModuleAction.selectModule(this.getProject());
            this.parentNode = module != null ? module.getDelegate() : null;
        }
        return true;
    }

    private Project getProject() {
        ObjectTypeDescription objectType = (ObjectTypeDescription)this.getSelection().as(ObjectTypeDescription.class);
        return FuegoProject.getFrom((TypeRef)objectType);
    }

    private void loadObject(String fileName) {
        try {
            String parentName = this.parentNode == null ? null : this.parentNode.getText();
            ComponentCatalog componentCatalog = this.getProject().getComponentCatalog();
            ImportOTDWrapper wrapper = ImportOTDWrapper.create((String)fileName, (ComponentCatalog)componentCatalog, (String)parentName);
            ObjectTypeDescription loadedObject = wrapper.getParent();
            if (loadedObject == null) {
                this.errorManager.reportError(DesignerMsg.IMPORT_ERROR("ERROR"));
            } else {
                String moduleName = wrapper.getModuleName();
                this.objectMap.put(moduleName.equals("") ? "" : moduleName + "." + loadedObject.getName(), loadedObject);
            }
        }
        catch (ConstructionException e) {
            this.errorManager.reportError(DesignerMsg.IMPORT_ERROR(e.getMessage()));
        }
    }

    private void loadObjects(boolean overwrite) {
        Set<Map.Entry<String, ObjectTypeDescription>> entries = this.objectMap.entrySet();
        ObjectTypeDescription parent = this.parentNode.get().asObject();
        for (Map.Entry<String, ObjectTypeDescription> entry : entries) {
            ObjectTypeDescription objToAdd = entry.getValue();
            TypeRef objFound = parent.findInnerType(objToAdd.getQualifiedName());
            if (objFound != null && overwrite) {
                this.remove(objFound);
            }
            if (this.errorManager.hasErrors()) continue;
            if (objFound == null || overwrite) {
                this.doAdd(parent, objToAdd);
            } else {
                this.errorManager.reportError(DesignerMsg.COMPONENT_WITH_SAME_NAME(objToAdd.getName()));
            }
            if (!this.errorManager.hasErrors()) continue;
            this.errorManager.showErrors();
        }
    }

    private void remove(TypeRef objToRemove) {
        ObjectTypeDescription otd = objToRemove.get().asObject();
        new DeleteCatalogNodeAction(otd, true).doIt();
    }

    private boolean loadToMap(File[] files) {
        if (this.objectMap == null) {
            this.objectMap = new HashMap<String, ObjectTypeDescription>();
        } else {
            this.objectMap.clear();
        }
        for (File file : files) {
            this.loadObject(file.getPath());
        }
        return !this.errorManager.hasErrors() && !this.objectMap.isEmpty();
    }

    private boolean requiresModuleSelection(File[] files) {
        if (this.requiresModuleSelection) {
            for (File file : files) {
                if (file.getName().toLowerCase().endsWith(".zip")) continue;
                return true;
            }
        }
        return false;
    }

    private File[] selectFilesToImport() {
        File[] result = null;
        FileChooser chooser = this.buildFileChooser();
        int returnVal = chooser.showOpenDialog((UiComponent)Ui.getRoot(), DesignerMsg.SELECT_EXPORTED_FILE_NAME, 1);
        if (returnVal == 0) {
            File[] selectedFiles = chooser.getSelectedFiles();
            result = selectedFiles.length <= 0 ? null : selectedFiles;
        }
        return result;
    }

    private static class ErrorManager {
        private StringBuffer errors;
        private StringBuffer warnings;

        private ErrorManager() {
        }

        public void displayResults() {
            if (!this.showErrors()) {
                this.showWarnings();
            }
        }

        public void reset() {
            this.errors = null;
            this.warnings = null;
        }

        private boolean hasErrors() {
            return this.errors != null && this.errors.length() > 0;
        }

        private boolean hasWarnings() {
            return this.warnings != null && this.warnings.length() > 0;
        }

        private void reportError(Msg errorMsg) {
            if (this.errors == null) {
                this.errors = new StringBuffer(0);
            }
            this.errors.append(errorMsg.toString());
            this.errors.append("\n\n");
        }

        private void reportWarning(String warningMsg) {
            if (this.warnings == null) {
                this.warnings = new StringBuffer(0);
            }
            this.warnings.append(warningMsg);
            this.warnings.append("\n");
        }

        private boolean showErrors() {
            boolean showErrors = this.hasErrors();
            if (showErrors) {
                MessageDialog.showError((Msg)DesignerMsg.IMPORT_CATALOG, (Msg)DesignerMsg.ERROR_IMPORTING, (Msg)UIMsg.TO_MSG((String)this.errors.toString()), null);
            }
            return showErrors;
        }

        private void showWarnings() {
            if (this.hasWarnings()) {
                MessageDialog.showWarning((Msg)DesignerMsg.IMPORT_CATALOG, (Msg)UIMsg.TO_MSG((String)this.warnings.toString()), null);
            }
        }
    }
}

