/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.action.OpenCatalogNodeAction;
import oracle.bpm.designer.catalog.tree.CatalogObjectTypeTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.Identifier;
import oracle.bpm.xobject.XObjectFactory;

public class ImplementTypeAction
extends DesignerAction {
    ObjectTypeDescription parent;
    private Project project;

    public ImplementTypeAction(Project project, ObjectTypeDescription parent) {
        super(DesignerMsg.CREATE_TYPE_IMPL);
        this.project = project;
        this.parent = parent;
        this.requires(CatalogObject.class);
        this.setShowOnDisabled(false);
    }

    @Override
    public boolean doIt() {
        return this.createImplementation();
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject objectType = (CatalogObject)selection.as(CatalogObject.class);
        this.setEnabled(!objectType.isModule());
    }

    private boolean createImplementation() {
        String name;
        ObjectTypeDescription obj = this.parent;
        if (obj == null || obj.isDefault()) {
            CatalogModule module = ModuleAction.selectModule(this.project);
            ObjectTypeDescription objectTypeDescription = obj = module != null ? module.getDelegate().asObject() : null;
            if (obj == null) {
                return false;
            }
        } else {
            CatalogObjectTypeTreeNode costn = (CatalogObjectTypeTreeNode)AbstractStudioWorkbench.getInstance().getProjectTree().getSelectedTreeNode().getParent();
            obj = costn.getObject();
            if (obj.isModule()) {
                obj = obj.getParent().asObject();
            }
        }
        int counter = 1;
        while (obj.findInnerType(name = this.parent.getName() + "Impl" + counter++) != null) {
        }
        boolean passed = false;
        while (!passed) {
            name = MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.CREATE_TYPE_IMPL, (Msg)DesignerMsg.IFACE_IMPL_NAME, null, (String)name);
            if (name == null) {
                return false;
            }
            passed = true;
            if (!Identifier.isValid(name)) {
                MessageDialog.showError((Msg)DesignerMsg.INVALID_IDENTIFIER);
                passed = false;
                continue;
            }
            if (obj.findInnerType(name) == null) continue;
            MessageDialog.showError((Msg)UIMsg.COMPONENT_NAME_ALREADY_EXISTS((String)name));
            passed = false;
        }
        ComponentCatalog catalog = this.project.getComponentCatalog();
        XObjectTypeDescription newType = XObjectFactory.createXObjectTypeDescription(name, false, catalog);
        newType.addSuperType(new SuperType(this.parent, 32768L));
        for (int i = 0; i < obj.asObject().getMemberCount(); ++i) {
            MethodTypeDescription pMember = obj.getMember(i);
            MethodTypeDescription member = pMember.clone();
            if (!pMember.isMethod() || pMember.isConstructor()) continue;
            ((ObjectTypeDescription)newType).addMember(member);
            if (member.getSignature() == null) continue;
            String methodName = Identifier.capitalize(member.getName() + "_signature");
            AttributeTypeDescription attr = new AttributeTypeDescription(methodName, TypeFactory.getString(), 33587212L);
            attr.setDefaultValue(pMember.getSignature());
            attr.setReadSignature(JavaClass.createGetAttrSignature(methodName, TypeFactory.getString().getJavaSignature()));
            attr.setWriteSignature(JavaClass.createSetAttrSignature(methodName, TypeFactory.getString().getJavaSignature()));
            ((ObjectTypeDescription)newType).addMember(attr);
        }
        ObjectTypeDescription parentType = obj.asObject();
        parentType.addInnerType(newType);
        MutableComponentCatalog repository = (MutableComponentCatalog)catalog;
        try {
            repository.add(newType);
        }
        catch (TypeCatalogException e) {
            MessageDialog.showError((Throwable)e);
        }
        OpenCatalogNodeAction oca = new OpenCatalogNodeAction();
        oca.runWithSelection(newType);
        return oca.isSuccess();
    }
}

