/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import oracle.bpm.draw.diagram.AuditProcessDiagrammer;
import oracle.bpm.draw.diagram.ProcessDiagrammer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.ui.utils.ImageIOFacade;
import org.jetbrains.annotations.NotNull;

public class GenerateProcessImageAction
extends BaseAction {
    private static GenerateProcessImageAction instance;

    private GenerateProcessImageAction() {
        super(Msg.QUOTE("DEBUG MODE: Generate Process Image"));
        this.requires(Process.class);
    }

    public static GenerateProcessImageAction getInstance() {
        if (instance == null) {
            instance = new GenerateProcessImageAction();
        }
        return instance;
    }

    public void run() {
        Process process = this.getProcess();
        AuditProcessDiagrammer diagrammer = new AuditProcessDiagrammer(process);
        this.storeImage("000-" + process.getId() + ".png", (ProcessDiagrammer)diagrammer);
    }

    private void storeImage(@NotNull String name, @NotNull ProcessDiagrammer diagrammer) {
        try {
            File file;
            Image image = Image.createFromBase64((String)diagrammer.getImage());
            File dir = new File(System.getProperty("user.home") + "/tmp/output");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(dir, name)).exists()) {
                file.createNewFile();
            }
            ImageIOFacade.writeImage((RenderedImage)((BufferedImage)image.asAwtImage()), (ImageExtension)ImageExtension.PNG, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Process getProcess() {
        return (Process)this.getSelection().as(Process.class);
    }
}

