/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Comparator;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.SeparatorTreeNode;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.catalog.tree.CatalogObjectStructureTreeNode;
import oracle.bpm.designer.catalog.tree.CatalogObjectTypeTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectAttributeMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectMethodMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectPresentationTreeNode;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class FuegoObjectAction
extends DesignerAction {
    private static final int GROUPS = 0;
    private static final int METHODS = 1;
    private static final int ATTRIBUTES = 2;
    private static final int TRANSFORMATIONS = 3;
    private static final int SEPARATORS = 4;
    private static final int PRESENTATIONS = 5;
    private static final int UNKOWN = 6;
    private static Comparator<TreeNode> fobjectComparator = null;
    static final long serialVersionUID = 632103101829849655L;
    static final long serialCheck = 3384798455617440081L;

    public FuegoObjectAction(Msg msg) {
        super(msg);
        this.requires(BpmObject.class);
    }

    public static Comparator<TreeNode> getFuegoObjectTreeNodeComparator() {
        if (fobjectComparator == null) {
            fobjectComparator = new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    int type2;
                    int type1 = FuegoObjectAction.getTreeNodeType(o1);
                    return type1 < (type2 = FuegoObjectAction.getTreeNodeType(o2)) ? -1 : (type1 > type2 ? 1 : o1.toString().compareTo(o2.toString()));
                }
            };
        }
        return fobjectComparator;
    }

    public static String getTypeAsString(int type) {
        switch (type) {
            case 0: {
                return "groups";
            }
            case 1: {
                return "methods";
            }
            case 2: {
                return "attributes";
            }
            case 3: {
                return "transformations";
            }
            case 4: {
                return "separators";
            }
            case 5: {
                return "presentations";
            }
        }
        return "UNKOWN";
    }

    public static void storeObjectIfEditorIsNotActive(CatalogObject catalogObject) {
        StudioEditor studioEditor = AbstractStudioWorkbench.getInstance().findEditorByObject(catalogObject);
        if (studioEditor == null) {
            FuegoObjectAction.storeObject(catalogObject.getObjectType());
        }
    }

    public static void storeObject(final ObjectTypeDescription otd) {
        try {
            FuegoWorker.post((FuegoWorker.Procedure)new FuegoWorker.Procedure(){

                public void run() throws TypeCatalogException {
                    FuegoObjectAction.getTypeRepository(CatalogObjectImpl.create((TypeRef)otd)).update(otd);
                    if (otd.isInnerType()) {
                        FuegoObjectAction.getTypeRepository(CatalogObjectImpl.create((TypeRef)otd)).update(otd.getParent().asObject());
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    protected static MutableComponentCatalog getTypeRepository(TypeRef ref) {
        return FuegoObjectAction.getTypeRepository(CatalogObjectImpl.create((TypeRef)ref));
    }

    protected static MutableComponentCatalog getTypeRepository(CatalogObject ref) {
        return (MutableComponentCatalog)ref.getProject().getComponentCatalog();
    }

    protected void updateEnableStatus(Selection sel) {
        CatalogObject catalogObject = (CatalogObject)sel.as(CatalogObject.class);
        this.setEnabled(this.isEditable(catalogObject));
    }

    protected boolean isEditable(@NotNull CatalogObject catalogObject) {
        ObjectTypeDescription objectType = catalogObject.getObjectType();
        return this.isEditableObjectType(objectType) && !catalogObject.isReadOnly();
    }

    private static int getTreeNodeType(TreeNode treeNode) {
        if (treeNode instanceof CatalogObjectStructureTreeNode || treeNode instanceof CatalogObjectTypeTreeNode) {
            return 0;
        }
        if (treeNode instanceof ObjectMethodMemberTreeNode) {
            return 1;
        }
        if (treeNode instanceof ObjectAttributeMemberTreeNode) {
            return 2;
        }
        if (treeNode instanceof SeparatorTreeNode) {
            return 4;
        }
        if (treeNode instanceof ObjectPresentationTreeNode) {
            return 5;
        }
        if (treeNode instanceof ObjectMemberTreeNode) {
            ObjectMemberTreeNode objectMember = (ObjectMemberTreeNode)treeNode;
            MethodTypeDescription member = objectMember.getMember();
            if (member.isAttribute()) {
                return 2;
            }
            if (member.isMethod()) {
                return 1;
            }
            return 6;
        }
        return 6;
    }

    private boolean isEditableObjectType(ObjectTypeDescription objectType) {
        return objectType.isBpmObject() && !objectType.isDefault();
    }
}

