/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import oracle.bpm.designer.action.Operation;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.MessageDialog;

public class ExportProcessOperation
implements Operation {
    private final File destinationDir;
    private final Process process;

    public ExportProcessOperation(Process process, File destinationDir) {
        this.process = process;
        this.destinationDir = destinationDir;
    }

    @Override
    public boolean run() {
        Process process = this.getProcess();
        File file = this.destinationDir;
        if (file != null) {
            try {
                Project project = process.getProject();
                project.getWriter().write((ProjectObject)process, (OutputStream)new FileOutputStream(file));
                project.getRepository().refresh(project);
                return true;
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }
        return false;
    }

    private Process getProcess() {
        return this.process;
    }
}

