/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeWriter;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.FileFilter;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class ExportPresentationAction
extends DesignerAction {
    private XFormPresentationModel model;
    static final long serialVersionUID = -7888165919758885546L;
    static final long serialCheck = 6725411836748489729L;

    public ExportPresentationAction(XFormPresentationModel model) {
        super(DesignerMsg.EXPORT);
        this.model = model;
    }

    @Override
    public boolean doIt() {
        boolean successfull = false;
        File selectedFile = this.getFile();
        if (selectedFile != null) {
            successfull = this.doStore(selectedFile);
        }
        return successfull;
    }

    public void unDoIt() {
    }

    private File getFile() {
        int res;
        File selectedFile;
        FileChooser chooser = new FileChooser();
        chooser.setName("export.presentation");
        chooser.setFileFilter(FileFilter.create(UIMsg.XFP_FILES, ".xfp"));
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory() + File.separator + this.model.getPresentationName() + ".xfp"));
        boolean accepted = chooser.showSaveDialog((UiComponent)Ui.getRoot()) == 0;
        File file = selectedFile = accepted ? chooser.getSelectedFile() : null;
        if (selectedFile != null && selectedFile.exists() && (res = MessageDialog.showQuestion((Msg)UIMsg.WARNING, (Msg)DesignerMsg.FILE_EXISTS_SAVE_ANYWAY, (int)9)) != 1) {
            selectedFile = null;
        }
        return selectedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStore(File selectedFile) {
        XObjectTypeDescription d = new XObjectTypeDescription("noName");
        d.setPModel(this.model, this.model.getPresentationName());
        boolean successfull = false;
        FileWriter writer = null;
        try {
            writer = new FileWriter(selectedFile);
            XmlWriter xml = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
            xml.setIndentAttributes(true);
            TypeWriter.writeXml(xml, d);
            xml.close();
        }
        catch (IOException e) {
            Log.logSevere(e);
            successfull = false;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.logSevere(e);
                    successfull = false;
                }
            }
        }
        return successfull;
    }
}

