/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.io.IOException;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.ProjectMultipleActionElement;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.FileFilter;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class ExportObjectAction
extends DesignerAction
implements ProjectMultipleActionElement {
    private File destinationDir;
    private ObjectTypeDescription object;
    private TypeRef ref;

    public ExportObjectAction(TypeRef ref) {
        super(DesignerMsg.EXPORT);
        this.ref = ref;
        this.requires(ObjectTypeDescription.class);
        this.setShowOnDisabled(false);
    }

    public ExportObjectAction(ObjectTypeDescription object) {
        this((TypeRef)object);
    }

    @Override
    public void setDestinationDir(File f) {
        this.destinationDir = f;
    }

    @Override
    public void run() {
        if (this.ref != null) {
            this.object = this.ref.get().asObject();
        }
        this.exportObject();
    }

    protected void updateEnableStatus(Selection selection) {
        ObjectTypeDescription objectType = (ObjectTypeDescription)selection.as(ObjectTypeDescription.class);
        this.setEnabled(!objectType.isInnerType() && (objectType.isBpmObject() || objectType.isEnum()));
    }

    private File getDestinationFile(File destinationDir) {
        return new File(destinationDir + File.separator + this.object.getText() + ".zip");
    }

    private FileChooser buildFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.setName("export.object");
        return chooser;
    }

    private boolean exportObject() {
        int res;
        File selectedFile;
        boolean hasInners;
        boolean bl = hasInners = this.object.getInnerTypeCount() > 0;
        if (this.destinationDir == null) {
            FileChooser chooser = this.buildFileChooser();
            FileFilter filter = FileFilter.create(UIMsg.EXPORTED_FILE_NAME, ".xml", ".xcdl", ".jar", ".zip");
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(this.getDestinationFile(chooser.getCurrentDirectory()));
            int returnVal = chooser.showSaveDialog((UiComponent)Ui.getRoot(), DesignerMsg.SELECT_EXPORTED_FILE_NAME);
            selectedFile = chooser.getSelectedFile();
            if (selectedFile == null || returnVal != 0) {
                return false;
            }
        } else {
            selectedFile = this.getDestinationFile(this.destinationDir);
        }
        if (!selectedFile.exists() && selectedFile.getPath().toLowerCase().lastIndexOf(".xcdl") == -1 && selectedFile.getPath().toLowerCase().lastIndexOf(".xml") == -1 && selectedFile.getPath().toLowerCase().lastIndexOf(".zip") == -1 && selectedFile.getPath().toLowerCase().lastIndexOf(".jar") == -1) {
            selectedFile = new File(selectedFile.getPath() + ".zip");
        }
        if (this.object.isBpmObject() && selectedFile.getPath().toLowerCase().lastIndexOf(".jar") == -1 && selectedFile.getPath().toLowerCase().lastIndexOf(".zip") == -1 && hasInners) {
            MessageDialog.showError((Msg)DesignerMsg.EXPORT_XO_INNER_ERROR);
            return false;
        }
        if (selectedFile.exists() && (res = MessageDialog.showQuestion((Msg)CoreMsg.WARNING, (Msg)DesignerMsg.FILE_EXISTS_SAVE_ANYWAY, (int)9)) != 1) {
            return false;
        }
        boolean exportFinish = false;
        try {
            exportFinish = XObjectTypeDescriptionHelper.exportObject((ObjectTypeDescription)this.object, (String)selectedFile.getPath());
        }
        catch (IOException ioe) {
            MessageDialog.showError(null, (Msg)DesignerMsg.WRITING_COMPONENT_ERROR(this.object.getName()), (Throwable)ioe);
        }
        return exportFinish;
    }
}

