/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.Clipboard;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.ModelActions;
import oracle.bpm.designer.command.PasteCopiedObjectsCommand;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;

public class DesignerPasteAction
extends DesignerAction {
    private Point targetLocation;
    private static DesignerPasteAction instance;

    private DesignerPasteAction() {
        super(UIMsg.PASTE);
        this.requires(Process.class);
    }

    public static DesignerPasteAction getInstance() {
        if (instance == null) {
            instance = new DesignerPasteAction();
        }
        return instance;
    }

    @Override
    public void run() {
        Selection currentSelection = this.getSelection();
        if (currentSelection != null) {
            LayoutModelCommand command;
            Process targetProcess = (Process)currentSelection.as(Process.class);
            ModelObjectSelection positionals = Clipboard.getInstance().getObjects();
            if (positionals != null && !positionals.isEmpty()) {
                this.getRunner().run((Command)((Object)new PasteCopiedObjectsCommand(positionals, targetProcess, this.targetLocation == null ? new Point(30, 30) : this.targetLocation)));
            }
            if ((command = ModelActions.getLayoutCommand(targetProcess, true)) != null) {
                this.getRunner().run((Command)command);
            }
        }
    }

    public void setTargetLocation(Point targetLocation) {
        this.targetLocation = targetLocation;
    }

    public static class ContextualDesignerPasteAction
    extends DesignerPasteAction
    implements SelectionListener,
    Clipboard.ClipboardListener {
        private static ContextualDesignerPasteAction contextualInstance;

        private ContextualDesignerPasteAction() {
            Clipboard.getInstance().addClipboardListener(this);
        }

        public static ContextualDesignerPasteAction getInstance() {
            if (contextualInstance == null) {
                contextualInstance = new ContextualDesignerPasteAction();
            }
            return contextualInstance;
        }

        public void selectionChanged(Selection sel) {
            this.setSelection(sel);
        }

        @Override
        public void clipboardChanged() {
            this.updateEnableStatus(null);
        }

        protected void updateEnableStatus(Selection sel) {
            this.setEnabled(Clipboard.getInstance().canPaste());
        }
    }
}

