/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.DesignerCopyAction;
import oracle.bpm.project.command.design.RemoveObjectsCommand;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;

public class DesignerCutAction
extends DesignerAction {
    private static DesignerCutAction instance;

    private DesignerCutAction() {
        super(UIMsg.CUT);
        this.setOrder(ActionOrder.BOTTOM);
        this.requires(ModelObjectSelection.class);
    }

    public static DesignerCutAction getInstance() {
        if (instance == null) {
            instance = new DesignerCutAction();
        }
        return instance;
    }

    @Override
    public void run() {
        ModelObjectSelection selectedObjects = (ModelObjectSelection)this.getSelection().as(ModelObjectSelection.class);
        if (selectedObjects != null) {
            DesignerCopyAction designerCopyAction = DesignerCopyAction.getInstance();
            designerCopyAction.setSelection(this.getSelection());
            designerCopyAction.run();
            this.getRunner().run((Command)new RemoveObjectsCommand(selectedObjects));
        }
    }

    public static class ContextualDesignerCutAction
    extends DesignerCutAction
    implements SelectionListener {
        private static ContextualDesignerCutAction contextualInstance;

        private ContextualDesignerCutAction() {
        }

        public static ContextualDesignerCutAction getInstance() {
            if (contextualInstance == null) {
                contextualInstance = new ContextualDesignerCutAction();
            }
            return contextualInstance;
        }

        public void selectionChanged(Selection sel) {
            this.setSelection(sel);
        }

        protected void updateEnableStatus(Selection sel) {
            ModelObjectSelection finalSelection = (ModelObjectSelection)sel.as(ModelObjectSelection.class);
            this.setEnabled(finalSelection != null && !finalSelection.isEmpty());
        }
    }
}

