/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.presentations.PresentationManager;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;

public class DeleteViewPresentationAction
extends DesignerAction {
    static DeleteViewPresentationAction instance;

    private DeleteViewPresentationAction() {
        super(UIMsg.MENU_DELETE);
        this.requires(Presentation.class);
    }

    public static DeleteViewPresentationAction getInstance() {
        if (instance == null) {
            instance = new DeleteViewPresentationAction();
        }
        return instance;
    }

    @Override
    public void run() {
        Presentation presentation = (Presentation)this.getSelection().as(Presentation.class);
        if (presentation != null) {
            boolean result;
            PresentationManager presentationManager = presentation.getProject().getPresentationManager();
            boolean isDefault = presentationManager.isDefaultPresentation(presentation);
            if (isDefault) {
                this.setMsg(DesignerMsg.RESTORE);
            }
            Msg confirmationMsg = isDefault ? DesignerMsg.CONFIRM_DEFAULT_PRESENTATION_RESTORE : DesignerMsg.CONFIRM_PRESENTATION_DELETE;
            int answer = MessageDialog.showQuestion((UiContainer)null, (Msg)DesignerMsg.DELETE_PRESENTATION, (Msg)confirmationMsg, null, (int)6, null);
            boolean bl = result = answer == 2;
            if (result) {
                try {
                    presentationManager.removePresentation(presentation);
                }
                catch (CouldNotDeleteResourceException e) {
                    MessageDialog.showError((Msg)e.getMsg());
                }
                catch (ProjectException e) {
                    MessageDialog.showError((Msg)e.getMsg());
                }
            }
        }
    }
}

