/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.tree.ViewNode;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.exception.ViewException;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.presentation.views.ViewManager;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;

public class DeleteViewAction
extends DesignerAction {
    private ViewNode viewNode;
    static final long serialVersionUID = 453448919569627602L;
    static final long serialCheck = 7088026140125965390L;

    public DeleteViewAction(Msg msg) {
        super(msg);
        this.requires(View.class);
    }

    public DeleteViewAction(ViewNode parent) {
        this(UIMsg.MENU_DELETE);
        this.viewNode = parent;
    }

    @Override
    public boolean doIt() {
        int answer;
        boolean result;
        Msg message = DesignerMsg.CONFIRM_VIEW_DELETE;
        View view = this.viewNode.getView();
        Project project = view.getProject();
        ViewManager viewManager = project.getViewManager();
        if (!view.getChildrenViews().isEmpty()) {
            message = DesignerMsg.CONFIRM_CHILDREN_VIEWS_DELETE;
        }
        boolean bl = result = (answer = MessageDialog.showQuestion((UiContainer)null, (Msg)DesignerMsg.DELETE_VIEW, (Msg)message, null, (int)6, null)) == 2;
        if (result) {
            this.closeEditors(view);
            try {
                viewManager.removeView(view);
            }
            catch (ViewException e) {
                MessageDialog.showError((Throwable)e);
            }
            catch (CouldNotDeleteResourceException e) {
                MessageDialog.showError((Msg)e.getMsg());
            }
        }
        return result;
    }

    public void unDoIt() {
    }

    private void closeEditors(View view) {
        if (!view.getChildrenViews().isEmpty()) {
            for (View childView : view.getChildrenViews()) {
                this.closeEditors(childView);
            }
        }
        this.getWorkbench().closeEditorForInput(view);
    }
}

