/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.design.RemoveObjectsCommand;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;

public class DeleteObjectAction
extends DesignerAction {
    private boolean confirm = true;

    public DeleteObjectAction(ProjectObject object) {
        this(object, null);
    }

    public DeleteObjectAction(ProjectObject object, String detail) {
        super(detail == null ? UIMsg.MENU_DELETE : UIMsg.DELETE_DETAIL((String)detail));
        this.setOrder(ActionOrder.BOTTOM);
        this.requires(object.getClass());
        this.setSelection(DefaultSelection.createSingle((Object)object));
    }

    @Override
    public void run() {
        int i = 1;
        ProjectObject object = (ProjectObject)this.getSelection().as(ProjectObject.class);
        if (this.confirm && !(object instanceof FlowElement)) {
            Msg deleteMsg = object.is(Project.class) ? DesignerMsg.CONFIRM_PROJECT_DELETE : DesignerMsg.DELETE_PROJECT_OBJECT(this.getObjectName());
            i = MessageDialog.showQuestion((UiContainer)Ui.getRoot(), (Msg)UIMsg.MENU_DELETE, (Msg)deleteMsg, null, (int)9, null);
        }
        if (i == 1) {
            try {
                ProjectObject parent = object.getParentObject();
                this.getRunner().run(this.getRemoveCommand(object, parent));
            }
            catch (Exception e) {
                MessageDialog.showError((UiContainer)Ui.getRoot(), (Throwable)e);
            }
        }
    }

    public void unDoIt() {
    }

    public void setConfirm(boolean b) {
        this.confirm = b;
    }

    protected String getObjectName() {
        ProjectObject object = (ProjectObject)this.getSelection().as(ProjectObject.class);
        return object.getId();
    }

    protected Object delete(ProjectObject projectObject) {
        try {
            projectObject.delete();
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return null;
    }

    protected void updateEnableStatus(Selection s) {
        this.setEnabled(((ProjectObject)s.as(ProjectObject.class)).isDeletable());
    }

    private Command getRemoveCommand(final ProjectObject object, final ProjectObject parent) {
        Command command = object instanceof FlowElement && !(object instanceof Process) ? new RemoveObjectsCommand(ModelObjectSelection.create((FlowElement[])new FlowElement[]{(FlowElement)object})) : new Command(){

            @Override
            public String getName() {
                return UIMsg.MENU_DELETE.getString();
            }

            @Override
            public Object getAffectedObject() {
                return parent;
            }

            @Override
            public void undo() {
                try {
                    if (parent instanceof ProjectObjectContainer) {
                        ((ProjectObjectContainer)parent).addChild(object);
                    }
                }
                catch (ProjectException e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public Object execute() throws ExecutionException {
                return DeleteObjectAction.this.delete(object);
            }
        };
        return command;
    }
}

